/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.request;

import com.atlassian.bitbucket.request.RequestLocal;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RequestLocalTestUtils {
    @Nonnull
    public static <T> RequestLocal<T> requestLocal() {
        return RequestLocalTestUtils.requestLocal(null);
    }

    @Nonnull
    public static <T> RequestLocal<T> requestLocal(@Nullable Supplier<Boolean> isActiveSupplier) {
        return new SimpleRequestLocal(isActiveSupplier);
    }

    private static class SimpleRequestLocal<T>
    implements RequestLocal<T> {
        private final Supplier<Boolean> activeSupplier;
        private T localValue;

        SimpleRequestLocal(Supplier<Boolean> activeSupplier) {
            this.activeSupplier = activeSupplier == null ? () -> true : activeSupplier;
        }

        public T compute(@Nonnull Function<? super T, ? extends T> mappingFunction) {
            if (this.isActive()) {
                this.localValue = mappingFunction.apply(this.localValue);
                return this.localValue;
            }
            return mappingFunction.apply(null);
        }

        public T computeIfAbsent(@Nonnull Supplier<? extends T> missingValueSupplier) {
            if (this.isActive()) {
                return this.localValue == null ? (this.localValue = missingValueSupplier.get()) : this.localValue;
            }
            return missingValueSupplier.get();
        }

        public T get() {
            if (this.isActive()) {
                return this.localValue;
            }
            return null;
        }

        public void ifPresent(@Nonnull Consumer<? super T> consumer) {
            if (this.isActive() && this.localValue != null) {
                consumer.accept(this.localValue);
            }
        }

        public boolean isActive() {
            return Boolean.TRUE.equals(this.activeSupplier.get());
        }

        public boolean isPresent() {
            return this.isActive() && this.localValue != null;
        }

        public T remove() {
            if (this.isActive()) {
                T value = this.localValue;
                this.localValue = null;
                return value;
            }
            return null;
        }

        public T removeIf(@Nonnull Predicate<? super T> predicate) {
            if (this.isActive() && this.localValue != null && predicate.test(this.localValue)) {
                return this.remove();
            }
            return null;
        }

        public boolean set(T value) {
            if (this.isActive()) {
                this.localValue = value;
                return true;
            }
            return false;
        }
    }
}

