/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.migration;

import com.atlassian.bitbucket.io.IoConsumer;
import com.atlassian.bitbucket.migration.ArchiveSource;
import com.atlassian.bitbucket.migration.EntrySource;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class SimpleArchiveSource
implements ArchiveSource {
    private final Path path;
    private final List<EntrySource> entries;

    public SimpleArchiveSource(Path path, List<EntrySource> entries) {
        this.path = path;
        this.entries = entries;
    }

    public void extractToDisk(@Nonnull Path target, @Nonnull Predicate<String> filter) throws IOException {
        for (EntrySource entry : this.entries) {
            if (!filter.test(entry.getPath().toString())) continue;
            entry.extractToDisk(target.resolve(entry.getPath()));
        }
    }

    @Nonnull
    public Path getPath() {
        return this.path;
    }

    public void read(@Nonnull IoConsumer<EntrySource> reader, @Nonnull Predicate<String> filter) throws IOException {
        for (EntrySource entry : this.entries) {
            if (!filter.test(entry.getPath().toString())) continue;
            reader.accept((Object)entry);
        }
    }
}

