/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.migration;

import com.atlassian.bitbucket.i18n.KeyedMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

class ErrorStub {
    private List<Message> errors = new ArrayList<Message>();
    private List<Message> warnings = new ArrayList<Message>();

    ErrorStub() {
    }

    public List<Message> getErrors() {
        return this.errors;
    }

    public List<Message> getWarnings() {
        return this.warnings;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    void addError(KeyedMessage message, Object entity) {
        this.errors.add(new Message(message, entity));
    }

    void addError(@Nonnull KeyedMessage message, Object entity, Throwable t) {
        this.errors.add(new Message(message, entity, t));
    }

    void addWarning(@Nonnull KeyedMessage message, Object entity, Throwable t) {
        this.warnings.add(new Message(message, entity, t));
    }

    void addWarning(KeyedMessage message, Object entity) {
        this.warnings.add(new Message(message, entity));
    }

    void reset() {
        this.errors = new ArrayList<Message>();
        this.warnings = new ArrayList<Message>();
    }

    public static class Message {
        private final KeyedMessage message;
        private final Object subject;
        private final Throwable throwable;

        public Message(KeyedMessage message, Object subject) {
            this(message, subject, null);
        }

        public Message(KeyedMessage message, Object subject, Throwable throwable) {
            this.message = Objects.requireNonNull(message, "message");
            this.subject = subject;
            this.throwable = throwable;
        }

        @Nonnull
        public KeyedMessage getMessage() {
            return this.message;
        }

        public Object getSubject() {
            return this.subject;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }
    }
}

