/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.junit;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogListener
implements TestRule {
    private final ch.qos.logback.classic.Logger loggerUnderTest;
    private final boolean quiet;
    private final RecordingAppender recordingAppender;

    public LogListener(@Nonnull Class<?> clazz) {
        this(LoggerFactory.getLogger(Objects.requireNonNull(clazz, "clazz")), true);
    }

    public LogListener(@Nonnull Class<?> clazz, boolean quiet) {
        this(LoggerFactory.getLogger(Objects.requireNonNull(clazz, "clazz")), quiet);
    }

    public LogListener(@Nonnull String loggerName) {
        this(LoggerFactory.getLogger((String)Objects.requireNonNull(loggerName, "loggerName")), true);
    }

    public LogListener(@Nonnull String loggerName, boolean quiet) {
        this(LoggerFactory.getLogger((String)Objects.requireNonNull(loggerName, "loggerName")), quiet);
    }

    public LogListener(@Nonnull Logger loggerUnderTest, boolean quiet) {
        Objects.requireNonNull(loggerUnderTest, "loggerUnderTest");
        if (!(loggerUnderTest instanceof ch.qos.logback.classic.Logger)) {
            throw new IllegalArgumentException("Only logback Logger is supported");
        }
        this.loggerUnderTest = (ch.qos.logback.classic.Logger)loggerUnderTest;
        this.quiet = quiet;
        this.recordingAppender = new RecordingAppender();
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                LogListener.this.recordingAppender.reset();
                boolean additive = LogListener.this.loggerUnderTest.isAdditive();
                LogListener.this.loggerUnderTest.addAppender((Appender)LogListener.this.recordingAppender);
                if (LogListener.this.quiet) {
                    LogListener.this.loggerUnderTest.setAdditive(false);
                }
                Level prevLevel = LogListener.this.loggerUnderTest.getLevel();
                LogListener.this.loggerUnderTest.setLevel(Level.DEBUG);
                try {
                    base.evaluate();
                }
                finally {
                    if (LogListener.this.quiet) {
                        LogListener.this.loggerUnderTest.setAdditive(additive);
                    }
                    LogListener.this.loggerUnderTest.detachAppender((Appender)LogListener.this.recordingAppender);
                    LogListener.this.loggerUnderTest.setLevel(prevLevel);
                }
            }
        };
    }

    public void assertDebug(@Nonnull Matcher<String> messageMatcher) {
        this.recordingAppender.assertMessagesLogged(Level.DEBUG, Objects.requireNonNull(messageMatcher, "messageMatcher"));
    }

    public void assertDebug(@Nonnull String message) {
        this.recordingAppender.assertMessagesLogged(Level.DEBUG, (Matcher<String>)CoreMatchers.containsString((String)Objects.requireNonNull(message, "message")));
    }

    public void assertError(@Nonnull Matcher<String> messageMatcher) {
        this.recordingAppender.assertMessagesLogged(Level.ERROR, Objects.requireNonNull(messageMatcher, "messageMatcher"));
    }

    public void assertError(@Nonnull String message) {
        this.recordingAppender.assertMessagesLogged(Level.ERROR, (Matcher<String>)CoreMatchers.containsString((String)Objects.requireNonNull(message, "message")));
    }

    public void assertInfo(@Nonnull Matcher<String> messageMatcher) {
        this.recordingAppender.assertMessagesLogged(Level.INFO, Objects.requireNonNull(messageMatcher, "messageMatcher"));
    }

    public void assertInfo(@Nonnull String message) {
        this.recordingAppender.assertMessagesLogged(Level.INFO, (Matcher<String>)CoreMatchers.containsString((String)Objects.requireNonNull(message, "message")));
    }

    public void assertWarn(@Nonnull Matcher<String> messageMatcher) {
        this.recordingAppender.assertMessagesLogged(Level.WARN, Objects.requireNonNull(messageMatcher, "messageMatcher"));
    }

    public void assertWarn(@Nonnull String message) {
        this.recordingAppender.assertMessagesLogged(Level.WARN, (Matcher<String>)CoreMatchers.containsString((String)Objects.requireNonNull(message, "message")));
    }

    public void reset() {
        this.recordingAppender.reset();
    }

    private static class RecordingAppender
    extends AppenderBase<ILoggingEvent> {
        private final List<ILoggingEvent> events = new CopyOnWriteArrayList<ILoggingEvent>();

        RecordingAppender() {
            this.start();
        }

        protected void append(ILoggingEvent eventObject) {
            this.events.add(eventObject);
        }

        void assertMessagesLogged(Level logLevel, Matcher<String> messageMatcher) {
            List messages = this.events.stream().filter(event -> event.getLevel().equals(logLevel)).map(ILoggingEvent::getFormattedMessage).collect(Collectors.toList());
            MatcherAssert.assertThat(messages, (Matcher)Matchers.hasItem(messageMatcher));
        }

        void reset() {
            this.events.clear();
        }
    }
}

