/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hamcrest;

import com.atlassian.bitbucket.hamcrest.RegexMatcher;
import com.atlassian.bitbucket.util.ShaUtils;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.TypeSafeMatcher;

public class MoreMatchers {
    private MoreMatchers() {
        throw new UnsupportedOperationException(MoreMatchers.class.getName() + " should not be instantiated");
    }

    @Nonnull
    public static <N extends Number> Matcher<N> between(final long min, final long max) {
        return new TypeSafeMatcher<N>(){

            public void describeTo(Description description) {
                description.appendText("a number between ").appendValue((Object)min).appendText(" and").appendValue((Object)max);
            }

            protected boolean matchesSafely(N n) {
                return ((Number)n).longValue() >= min && ((Number)n).longValue() <= max;
            }
        };
    }

    public static <T, S extends T> Matcher<T> cast(final Matcher<S> matcher) {
        return new BaseMatcher<T>(){

            public void describeTo(Description description) {
                matcher.describeTo(description);
            }

            public boolean matches(Object o) {
                try {
                    Object s = o;
                    return matcher.matches(s);
                }
                catch (ClassCastException e) {
                    return false;
                }
            }

            public void describeMismatch(Object o, Description description) {
                try {
                    Object s = o;
                    matcher.describeMismatch(s, description);
                }
                catch (ClassCastException e) {
                    description.appendText("'Actual value not of desired matcher type : ").appendValue(o).appendText("'");
                }
            }
        };
    }

    @Nonnull
    @SafeVarargs
    public static <E, I extends Iterable<? extends E>> Matcher<I> contains(@Nonnull Class<I> iterableType, @Nonnull Class<E> elementType, Matcher<? super E> ... matchers) {
        return Matchers.contains(matchers);
    }

    public static Matcher<String> containsInOrder(final CharSequence ... substrings) {
        return new TypeSafeMatcher<String>(){

            public boolean matchesSafely(String item) {
                int index = -1;
                for (CharSequence substring : substrings) {
                    index = item.indexOf(substring.toString(), index);
                    if (index >= 0) continue;
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("a string that contains (in order): ").appendValueList("(", ",", ")", (Object[])substrings);
            }
        };
    }

    public static <T> Matcher<T> forPredicate(@Nonnull Predicate<T> predicate) {
        return MoreMatchers.forPredicate(predicate, null);
    }

    public static <T> Matcher<T> forPredicate(final @Nonnull Predicate<T> predicate, final @Nullable String description) {
        Objects.requireNonNull(predicate, "predicate");
        return new TypeSafeMatcher<T>(){

            protected boolean matchesSafely(T item) {
                return predicate.test(item);
            }

            public void describeTo(Description matcherDescription) {
                matcherDescription.appendText(description);
            }
        };
    }

    public static Matcher<String> isSha1() {
        return RegexMatcher.matches(ShaUtils.PATTERN_HASH);
    }

    @Nonnull
    public static <N extends Number> Matcher<N> longEqual(final long value) {
        return new TypeSafeMatcher<N>(){

            public void describeTo(Description description) {
                description.appendText("a number equal to ").appendValue((Object)value);
            }

            protected boolean matchesSafely(N n) {
                return ((Number)n).longValue() == value;
            }
        };
    }

    @Nonnull
    public static <E> Matcher<Iterable<? extends E>> isSorted(final @Nonnull Comparator<E> comparator) {
        Objects.requireNonNull(comparator, "comparator");
        final Comparator<E> nullSafeComparator = Comparator.nullsLast(comparator);
        return new TypeSafeMatcher<Iterable<? extends E>>(){

            protected boolean matchesSafely(Iterable<? extends E> iterable) {
                Iterator iterator = iterable.iterator();
                if (!iterator.hasNext()) {
                    return false;
                }
                Object previous = iterator.next();
                while (iterator.hasNext()) {
                    Object current = iterator.next();
                    if (nullSafeComparator.compare(previous, current) > 0) {
                        return false;
                    }
                    previous = current;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("Expected collection to be sorted in ascending order by comparator ").appendValue((Object)comparator);
            }
        };
    }

    public static Matcher<Path> pathWithFilename(final String expectedName) {
        return new TypeSafeDiagnosingMatcher<Path>(){

            public void describeTo(Description description) {
                description.appendValue((Object)expectedName);
            }

            protected boolean matchesSafely(Path item, Description mismatchDescription) {
                if (item == null) {
                    mismatchDescription.appendText("Item is null.");
                    return false;
                }
                if (!expectedName.equals(item.getFileName().toString())) {
                    mismatchDescription.appendValue((Object)item.getFileName().toString());
                    return false;
                }
                return true;
            }
        };
    }
}

