/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hamcrest;

import java.util.Date;
import liquibase.change.ColumnConfig;
import liquibase.change.core.InsertDataChange;
import liquibase.changelog.ChangeSet;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class LiquibaseMatchers {
    private LiquibaseMatchers() {
        throw new UnsupportedOperationException("Attempt to instantiate utility class");
    }

    public static HasTableName hasTableName(String tableName) {
        return new HasTableName(tableName);
    }

    public static HasDbms hasDbms(String dbms) {
        return new HasDbms(dbms);
    }

    public static <V> ColumnConfigMatcher columnConfig(String columnName, V columnValue) {
        return new ColumnConfigMatcher<V>(columnName, columnValue);
    }

    public static final class ColumnConfigMatcher<V>
    extends TypeSafeMatcher<ColumnConfig> {
        private final String columnName;
        private final V columnValue;

        public ColumnConfigMatcher(String columnName, V columnValue) {
            this.columnName = columnName;
            this.columnValue = columnValue;
        }

        public boolean matchesSafely(ColumnConfig columnConfig) {
            if (!this.columnName.equals(columnConfig.getName())) {
                return false;
            }
            if (this.columnValue instanceof Boolean) {
                return this.columnValue.equals(columnConfig.getValueBoolean());
            }
            if (this.columnValue instanceof Date) {
                return this.columnValue.equals(columnConfig.getValueDate());
            }
            if (this.columnValue instanceof Number) {
                return this.columnValue.equals(columnConfig.getValueNumeric().longValue());
            }
            return this.columnValue.equals(columnConfig.getValueObject());
        }

        public void describeTo(Description description) {
            description.appendText("has name: ").appendValue((Object)this.columnName).appendText(" and has value: ").appendValue(this.columnValue);
        }
    }

    public static final class HasDbms
    extends TypeSafeMatcher<ChangeSet> {
        private final String dbms;

        public HasDbms(String dbms) {
            this.dbms = dbms;
        }

        public boolean matchesSafely(ChangeSet changeSet) {
            return changeSet.getDbmsSet().contains(this.dbms);
        }

        public void describeTo(Description description) {
            description.appendText("has dbms");
        }
    }

    public static final class HasTableName
    extends TypeSafeMatcher<InsertDataChange> {
        private final String tableName;

        public HasTableName(String tableName) {
            this.tableName = tableName;
        }

        public boolean matchesSafely(InsertDataChange insertDataChange) {
            return insertDataChange.getTableName().equals(this.tableName);
        }

        public void describeTo(Description description) {
            description.appendText("has table name: ").appendValue((Object)this.tableName);
        }
    }
}

