/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hamcrest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DomMatcher
extends TypeSafeDiagnosingMatcher<String> {
    private static final XPathExpression EMPTY_TEXT_XPATH;
    private final String expected;

    public DomMatcher(String expected) {
        this.expected = DomMatcher.serialize(DomMatcher.normalize(DomMatcher.parseXML(expected)));
    }

    public static DomMatcher matchesNormalizedDom(String xml) {
        return new DomMatcher(xml);
    }

    public static String normalize(String xml) {
        return DomMatcher.serialize(DomMatcher.normalize(DomMatcher.parseXML(xml)));
    }

    public void describeTo(Description description) {
        description.appendText(this.expected);
    }

    protected boolean matchesSafely(String item, Description mismatchDescription) {
        String normalized = DomMatcher.serialize(DomMatcher.normalize(DomMatcher.parseXML(item)));
        if (!this.expected.equals(normalized)) {
            mismatchDescription.appendText(normalized);
            return false;
        }
        return true;
    }

    private static Document normalize(Document doc) {
        try {
            LinkedList<Node> queue = new LinkedList<Node>();
            queue.add(doc);
            while (!queue.isEmpty()) {
                Node node = (Node)queue.removeFirst();
                node.normalize();
                NodeList childNodes = node.getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node child = childNodes.item(i);
                    queue.add(child);
                }
            }
            NodeList emptyTextNodes = (NodeList)EMPTY_TEXT_XPATH.evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < emptyTextNodes.getLength(); ++i) {
                Node emptyTextNode = emptyTextNodes.item(i);
                emptyTextNode.getParentNode().removeChild(emptyTextNode);
            }
            return doc;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    private static Document parseXML(String str) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            return documentBuilder.parse(new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private static String serialize(Document document) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "html");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(document);
            transformer.transform(source, result);
            return result.getWriter().toString();
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            EMPTY_TEXT_XPATH = XPathFactory.newInstance().newXPath().compile("//text()[normalize-space(.) = '']");
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("Static initialization failed", e);
        }
    }
}

