/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.features;

import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.features.EnabledDarkFeatures;
import com.atlassian.sal.api.features.EnabledDarkFeaturesBuilder;
import com.atlassian.sal.api.user.UserKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SimpleDarkFeatureManager
implements DarkFeatureManager {
    private static final UserKey CURRENT = new UserKey("");
    private final Set<String> globalFeatures = new HashSet<String>();
    private final Map<String, Set<String>> userFeatures = new HashMap<String, Set<String>>();

    public boolean canManageFeaturesForAllUsers() {
        return true;
    }

    public void disableFeatureForAllUsers(String feature) {
        this.globalFeatures.remove(feature);
    }

    public void disableFeatureForCurrentUser(String feature) {
        this.disableFeatureForUser(CURRENT, feature);
    }

    public void disableFeatureForUser(UserKey userKey, String feature) {
        Set<String> features = this.getFeaturesForUser(userKey);
        if (features != null) {
            features.remove(feature);
        }
    }

    public void enableFeatureForAllUsers(String feature) {
        this.globalFeatures.add(feature);
    }

    public void enableFeatureForCurrentUser(String feature) {
        this.enableFeatureForUser(CURRENT, feature);
    }

    public void enableFeatureForUser(UserKey userKey, String feature) {
        this.userFeatures.computeIfAbsent(SimpleDarkFeatureManager.keyToUser(userKey), ignored -> new HashSet()).add(feature);
    }

    public EnabledDarkFeatures getFeaturesEnabledForAllUsers() {
        return new EnabledDarkFeaturesBuilder().featuresEnabledForAllUsers(this.globalFeatures).build();
    }

    public EnabledDarkFeatures getFeaturesEnabledForCurrentUser() {
        return this.getFeaturesEnabledForUser(CURRENT);
    }

    public EnabledDarkFeatures getFeaturesEnabledForUser(@Nullable UserKey userKey) {
        return new EnabledDarkFeaturesBuilder().featuresEnabledForAllUsers(this.globalFeatures).featuresEnabledForCurrentUser(this.getFeaturesForUser(userKey)).build();
    }

    @Nonnull
    public Optional<Boolean> isEnabledForAllUsers(@Nonnull String feature) {
        return Optional.of(this.globalFeatures.contains(feature));
    }

    @Nonnull
    public Optional<Boolean> isEnabledForCurrentUser(@Nonnull String feature) {
        return this.isEnabledForUser(CURRENT, feature);
    }

    @Nonnull
    public Optional<Boolean> isEnabledForUser(@Nullable UserKey userKey, @Nonnull String feature) {
        if (this.globalFeatures.contains(feature)) {
            return Optional.of(Boolean.TRUE);
        }
        String user = SimpleDarkFeatureManager.keyToUser(userKey);
        return Optional.of(this.userFeatures.getOrDefault(user, Collections.emptySet()).contains(feature));
    }

    public boolean isFeatureEnabledForAllUsers(String feature) {
        return this.isEnabledForAllUsers(feature).orElse(Boolean.FALSE);
    }

    public boolean isFeatureEnabledForCurrentUser(String feature) {
        return this.isEnabledForCurrentUser(feature).orElse(Boolean.FALSE);
    }

    public boolean isFeatureEnabledForUser(@Nullable UserKey userKey, String feature) {
        return this.isEnabledForUser(userKey, feature).orElse(Boolean.FALSE);
    }

    private static String keyToUser(@Nullable UserKey userKey) {
        return userKey == null ? null : userKey.toString();
    }

    private Set<String> getFeaturesForUser(UserKey userKey) {
        return this.userFeatures.get(SimpleDarkFeatureManager.keyToUser(userKey));
    }
}

