/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.concurrent;

import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.concurrent.PullRequestLock;
import com.atlassian.bitbucket.concurrent.RepositoryLock;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;

public class SimpleLockService
implements LockService {
    private ConcurrentMap<String, ReentrantLock> namedLocks = Maps.newConcurrentMap();

    @Nonnull
    public Lock getLock(@Nonnull String s) {
        return this.getLock("named.", s);
    }

    @Nonnull
    public PullRequestLock getPullRequestLock(@Nonnull String lockName) {
        return new SimplePullRequestLock(lockName);
    }

    @Nonnull
    public RepositoryLock getRepositoryLock(@Nonnull String lockName) {
        return new SimpleRepositoryLock(lockName);
    }

    private ReentrantLock getLock(String prefix, String name) {
        String fqName = prefix + name;
        return this.namedLocks.computeIfAbsent(fqName, key -> new ReentrantLock());
    }

    private abstract class SimpleResourceLock {
        private final String prefix;

        SimpleResourceLock(String prefix, String lockName) {
            this.prefix = prefix + "." + lockName;
        }

        public <T, E extends Exception> T withLock(@Nonnull String resourceId, @Nonnull Operation<T, E> operation) throws E {
            try (LockGuard ignored = LockGuard.lock((Lock)SimpleLockService.this.getLock(this.prefix + "." + resourceId));){
                Object object = operation.perform();
                return (T)object;
            }
        }
    }

    private class SimpleRepositoryLock
    extends SimpleResourceLock
    implements RepositoryLock {
        SimpleRepositoryLock(String lockName) {
            super("repo", lockName);
        }

        public <T, E extends Exception> T withLock(int repositoryId, @Nonnull Operation<T, E> operation) throws E {
            return this.withLock(Integer.toString(repositoryId), operation);
        }

        public <T, E extends Exception> T withLock(@Nonnull Repository repository, @Nonnull Operation<T, E> operation) throws E {
            return this.withLock(repository.getId(), operation);
        }
    }

    private class SimplePullRequestLock
    extends SimpleResourceLock
    implements PullRequestLock {
        SimplePullRequestLock(String lockName) {
            super("pull-request", lockName);
        }

        public <T, E extends Exception> T withLock(int repositoryId, long pullRequestId, @Nonnull Operation<T, E> operation) throws E {
            return this.withLock(repositoryId + "." + pullRequestId, operation);
        }

        public <T, E extends Exception> T withLock(@Nonnull PullRequest pullRequest, @Nonnull Operation<T, E> operation) throws E {
            return this.withLock(pullRequest.getToRef().getRepository().getId(), pullRequest.getId(), operation);
        }
    }
}

