/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket;

import com.jayway.jsonassert.JsonAssert;
import com.jayway.jsonassert.JsonAsserter;
import java.util.function.Consumer;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;

public abstract class JsonMatcher
extends TypeSafeMatcher<String> {
    private final Consumer<JsonAsserter> test;

    public JsonMatcher(Consumer<JsonAsserter> test) {
        this.test = test;
    }

    protected boolean matchesSafely(String json) {
        try {
            this.test.accept(JsonAssert.with((String)json));
            return true;
        }
        catch (AssertionError | Exception e) {
            return false;
        }
    }

    public static Matcher<String> propEqualsIgnoreCase(final String path, final String value) {
        return new JsonMatcher(json -> json.assertThat(path, Matchers.equalToIgnoringCase((String)value))){

            public void describeTo(Description description) {
                description.appendText("JSON path ").appendValue((Object)path).appendText(" with case-insensitive string \"").appendValue((Object)value).appendText("\"");
            }
        };
    }

    public static <T> Matcher<String> prop(final String path, final Matcher<T> value) {
        return new JsonMatcher(json -> json.assertThat(path, value)){

            public void describeTo(Description description) {
                description.appendText("JSON path ").appendValue((Object)path).appendText(" ").appendDescriptionOf((SelfDescribing)value);
            }
        };
    }

    public static Matcher<String> propNotDefined(final String path) {
        return new JsonMatcher(json -> json.assertNotDefined(path)){

            public void describeTo(Description description) {
                description.appendText("JSON path should not be defined ").appendValue((Object)path);
            }
        };
    }

    public static Matcher<String> propNotNull(final String path) {
        return new JsonMatcher(json -> json.assertNotNull(path)){

            public void describeTo(Description description) {
                description.appendText("Non-null JSON path ").appendValue((Object)path);
            }
        };
    }
}

