/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.search;

import com.atlassian.bitbucket.search.ElasticsearchSingleNode;
import com.atlassian.bitbucket.util.MoreFiles;
import com.google.common.base.MoreObjects;
import io.atlassian.fugue.Pair;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.env.Environment;
import org.elasticsearch.http.HttpInfo;
import org.elasticsearch.node.InternalSettingsPreparer;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeValidationException;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.transport.Netty4Plugin;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;

@Deprecated
public final class EmbeddedElasticsearchSingleNode
extends ElasticsearchSingleNode {
    private static final Random RANDOM = new Random();
    private final int tcpPort;
    private final int httpPort;
    private Path homeDirectory;
    private Node node;

    EmbeddedElasticsearchSingleNode(Integer httpPort, Integer tcpPort) {
        this.httpPort = (Integer)MoreObjects.firstNonNull((Object)httpPort, (Object)29300);
        this.tcpPort = (Integer)MoreObjects.firstNonNull((Object)tcpPort, (Object)29200);
    }

    @Nonnull
    public String nodeName() {
        return "node_s_0";
    }

    @Override
    public List<String> analyze(String input, String analyzer) {
        AnalyzeAction.Request analyzeRequest = (AnalyzeAction.Request)this.node.client().admin().indices().prepareAnalyze("bitbucket-search", input).setAnalyzer(analyzer).request();
        AnalyzeAction.Response response = (AnalyzeAction.Response)this.node.client().admin().indices().analyze(analyzeRequest).actionGet();
        List tokens = response.getTokens();
        return tokens.stream().map(AnalyzeAction.AnalyzeToken::getTerm).collect(Collectors.toList());
    }

    @Override
    public void checkClusterHealth() {
        ClusterHealthResponse response = (ClusterHealthResponse)this.node.client().admin().cluster().health(new ClusterHealthRequest().timeout(TimeValue.timeValueSeconds((long)60L)).waitForYellowStatus()).actionGet();
        Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)ClusterHealthStatus.GREEN));
        Assert.assertFalse((String)"Health request shouldn't be timed out", (boolean)response.isTimedOut());
        Assert.assertThat((String)"There should be at least one active primary shard", (Object)response.getActivePrimaryShards(), (Matcher)Matchers.is((Object)1));
    }

    @Override
    public Map<String, List<String>> getAliases() {
        ImmutableOpenMap aliases = ((GetAliasesResponse)this.node.client().admin().indices().prepareGetAliases(new String[0]).get()).getAliases();
        return StreamSupport.stream(aliases.spliterator(), false).map(entry -> Pair.pair((Object)entry.key, ((List)entry.value).stream().map(AliasMetaData::getAlias).collect(Collectors.toList()))).collect(Collectors.toMap(Pair::left, Pair::right));
    }

    @Override
    @Nonnull
    public URI serverBaseUrl() {
        InetSocketAddress address = this.getHttpAddress();
        return URI.create("http://" + address.getHostName() + ":" + address.getPort());
    }

    public void cleanup(boolean restartNode) {
        EmbeddedElasticsearchSingleNode.assertAcked((AcknowledgedResponse)this.nativeClient().admin().indices().prepareDelete(new String[]{"*"}).get());
        if (restartNode) {
            this.reset();
        }
        MetaData metaData = ((ClusterStateResponse)this.nativeClient().admin().cluster().prepareState().get()).getState().getMetaData();
        Assert.assertThat((String)("test leaves persistent cluster metadata behind: " + metaData.persistentSettings().keySet()), (Object)metaData.persistentSettings().keySet().size(), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((String)("test leaves transient cluster metadata behind: " + metaData.transientSettings().keySet()), (Object)metaData.transientSettings().keySet().size(), (Matcher)Matchers.equalTo((Object)0));
    }

    @Override
    protected void before() {
        this.restartNode();
    }

    @Override
    protected void after() {
        this.shutdown();
    }

    @Override
    public String getVersion() {
        NodesInfoResponse nodesInfo = (NodesInfoResponse)this.nativeClient().admin().cluster().prepareNodesInfo(new String[0]).get();
        List nodes = nodesInfo.getNodes();
        return ((NodeInfo)nodes.get(0)).getVersion().toString();
    }

    @Nonnull
    private String clusterName() {
        return "cluster-" + RANDOM.nextLong();
    }

    @Nonnull
    private Client nativeClient() {
        return this.node.client();
    }

    private void restartNode() {
        this.reset();
    }

    private void shutdown() {
        this.stopNode();
        if (this.homeDirectory != null) {
            try {
                MoreFiles.deleteRecursively((Path)this.homeDirectory);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private InetSocketAddress getHttpAddress() {
        NodesInfoResponse nodesInfo = (NodesInfoResponse)this.nativeClient().admin().cluster().prepareNodesInfo(new String[0]).get();
        List nodes = nodesInfo.getNodes();
        Assert.assertThat((Object)nodes, (Matcher)Matchers.not((Matcher)Matchers.empty()));
        NodeInfo node = (NodeInfo)nodes.get(0);
        HttpInfo http = node.getHttp();
        BoundTransportAddress address = http.address();
        TransportAddress publishAddress = address.publishAddress();
        return publishAddress.address();
    }

    private void startNode() {
        assert (this.node == null);
        this.node = this.createAndStartNewNode();
    }

    private void reset() {
        this.stopNode();
        this.startNode();
    }

    private void stopNode() {
        Node node = this.node;
        this.node = null;
        if (node != null) {
            try {
                node.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Error closing node", e);
            }
        }
    }

    private Node createAndStartNewNode() {
        this.homeDirectory = this.createTempHomeDirectory();
        Settings settings = Settings.builder().put(Environment.PATH_HOME_SETTING.getKey(), this.homeDirectory).put(ClusterName.CLUSTER_NAME_SETTING.getKey(), this.clusterName()).put(Node.NODE_NAME_SETTING.getKey(), this.nodeName()).put(Node.NODE_DATA_SETTING.getKey(), true).put(Node.NODE_MASTER_SETTING.getKey(), true).put(EsExecutors.PROCESSORS_SETTING.getKey(), 1).put(NetworkModule.TRANSPORT_TYPE_SETTING.getKey(), "local").put("http.port", this.httpPort).put("transport.port", this.tcpPort).build();
        NodeWithPlugins node = new NodeWithPlugins(settings, Collections.singleton(Netty4Plugin.class));
        Assert.assertTrue((boolean)DiscoveryNode.nodeRequiresLocalStorage((Settings)settings));
        try {
            return node.start();
        }
        catch (NodeValidationException e) {
            throw new RuntimeException("Error starting node", e);
        }
    }

    private Path createTempHomeDirectory() {
        try {
            return Files.createTempDirectory("es-" + this.nodeName(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create temporary directory", e);
        }
    }

    private static void assertAcked(AcknowledgedResponse response) {
        MatcherAssert.assertThat((String)(response.getClass().getSimpleName() + " failed - not acked"), (Object)response.isAcknowledged(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    private static class NodeWithPlugins
    extends Node {
        NodeWithPlugins(Settings settings, Collection<Class<? extends Plugin>> classpathPlugins) {
            super(InternalSettingsPreparer.prepareEnvironment((Settings)settings, null, null, () -> "default"), classpathPlugins, false);
        }
    }
}

