/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.search;

import com.atlassian.bitbucket.search.ElasticsearchSingleNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class DockerElasticsearchSingleNode
extends ElasticsearchSingleNode {
    private static final JsonParser parser = new JsonParser();
    private final String hostName;
    private final int port;
    private RestClient client;

    DockerElasticsearchSingleNode(String hostName, int port) {
        this.hostName = hostName;
        this.port = port;
    }

    @Override
    public List<String> analyze(String input, String analyzer) {
        try {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("analyzer", analyzer);
            jsonObject.addProperty("text", input);
            NStringEntity entity = new NStringEntity(jsonObject.toString(), ContentType.APPLICATION_JSON);
            Request request = new Request("GET", "/bitbucket-search/_analyze/");
            request.setEntity((HttpEntity)entity);
            Response response = this.client.performRequest(request);
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            JsonObject responseObject = parser.parse(responseBody).getAsJsonObject();
            JsonArray tokens = responseObject.getAsJsonArray("tokens");
            ImmutableList.Builder builder = ImmutableList.builder();
            for (JsonElement token : tokens) {
                builder.add((Object)token.getAsJsonObject().get("token").getAsString());
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to analyze", e);
        }
    }

    @Override
    public void checkClusterHealth() {
        try {
            ImmutableMap params = ImmutableMap.of((Object)"wait_for_status", (Object)"yellow", (Object)"timeout", (Object)"60s");
            Request request = new Request("GET", "/_cluster/health");
            request.addParameters((Map)params);
            Response response = this.client.performRequest(request);
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            JsonObject responseObject = parser.parse(responseBody).getAsJsonObject();
            ClusterHealthStatus healthStatus = ClusterHealthStatus.fromString((String)responseObject.get("status").getAsString());
            Assert.assertThat((Object)healthStatus, (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)ClusterHealthStatus.YELLOW), (Matcher)Matchers.equalTo((Object)ClusterHealthStatus.GREEN)));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to check cluster health", e);
        }
    }

    @Override
    public Map<String, List<String>> getAliases() {
        try {
            Response response = this.client.performRequest(new Request("GET", "/_alias/"));
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            JsonObject responseObject = parser.parse(responseBody).getAsJsonObject();
            return responseObject.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, this::getAliasesName));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to retrieve aliases");
        }
    }

    @Override
    @Nonnull
    public URI serverBaseUrl() {
        return URI.create("http://" + this.hostName + ":" + this.port);
    }

    @Override
    protected void before() throws Throwable {
        this.client = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(this.hostName, this.port, "http")}).setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectionRequestTimeout(9999)).build();
    }

    @Override
    protected void after() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to close connection to elasticsearch");
        }
    }

    @Override
    public String getVersion() {
        try {
            Response response = this.client.performRequest(new Request("GET", "/_nodes"));
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            JsonObject responseObject = parser.parse(responseBody).getAsJsonObject();
            return ((JsonElement)((Map.Entry)responseObject.getAsJsonObject("nodes").entrySet().iterator().next()).getValue()).getAsJsonObject().get("version").getAsString();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to retrieve version");
        }
    }

    private List<String> getAliasesName(Map.Entry<String, JsonElement> entry) {
        return entry.getValue().getAsJsonObject().getAsJsonObject("aliases").entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toList());
    }
}

