/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.migration;

import com.atlassian.bitbucket.attribute.AttributeMap;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.io.IoConsumer;
import com.atlassian.bitbucket.io.IoFunction;
import com.atlassian.bitbucket.migration.ArchiveSource;
import com.atlassian.bitbucket.migration.EntityImportMapping;
import com.atlassian.bitbucket.migration.EntrySource;
import com.atlassian.bitbucket.migration.ErrorStub;
import com.atlassian.bitbucket.migration.ImportContext;
import com.atlassian.bitbucket.migration.Importer;
import com.atlassian.bitbucket.migration.MigrationEntityType;
import com.atlassian.bitbucket.migration.SimpleEntityImportMapping;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestableImportContext
extends TestWatcher
implements ImportContext {
    private final Set<MigrationEntityType<?>> assertedMappings = new HashSet();
    private final AttributeMap attributeMap = new AttributeMap();
    private String currentHierarchyId;
    private final LinkedList<Object> entries = new LinkedList();
    private final ErrorStub errorStub = new ErrorStub();
    private final Map<MigrationEntityType<?>, SimpleEntityImportMapping<?>> importMapping = new HashMap();
    private volatile boolean noMoreInteractions;

    public void addError(@Nonnull KeyedMessage message, Object entity) {
        this.checkMoreInteractionsAllowed();
        this.errorStub.addError(message, entity);
    }

    public void addError(@Nonnull KeyedMessage message, Object entity, Throwable t) {
        this.checkMoreInteractionsAllowed();
        this.errorStub.addError(message, entity, t);
    }

    public void addWarning(@Nonnull KeyedMessage message, Object entity) {
        this.checkMoreInteractionsAllowed();
        this.errorStub.addWarning(message, entity);
    }

    public void addWarning(@Nonnull KeyedMessage message, Object entity, Throwable t) {
        this.checkMoreInteractionsAllowed();
        this.errorStub.addWarning(message, entity, t);
    }

    public List<ErrorStub.Message> errors() {
        return this.errorStub.getErrors();
    }

    @Nonnull
    public Asserter expect() {
        return new Asserter();
    }

    @Nonnull
    public AttributeMap getAttributeMap() {
        return this.attributeMap;
    }

    @Nonnull
    public Optional<String> getCurrentHierarchyId() {
        return Optional.ofNullable(this.currentHierarchyId);
    }

    @Nonnull
    public <T> SimpleEntityImportMapping<T> getEntityMapping(@Nonnull MigrationEntityType<T> entityType) {
        this.checkMoreInteractionsAllowed();
        return this.importMapping.computeIfAbsent(entityType, migrationEntityType -> (SimpleEntityImportMapping)Mockito.spy(new SimpleEntityImportMapping()));
    }

    public boolean hasError(String messageId, Object subject) {
        return this.errors().stream().anyMatch(message -> message.getMessage().getKey().equals(messageId) && message.getSubject() == subject);
    }

    public boolean hasErrors() {
        return this.errorStub.hasErrors();
    }

    public boolean hasWarning(String messageId, Object subject) {
        return this.warnings().stream().anyMatch(message -> message.getMessage().getKey().equals(messageId) && message.getSubject() == subject);
    }

    public boolean hasWarnings() {
        return this.errorStub.hasWarnings();
    }

    public Mock mock() {
        return new Mock();
    }

    public void run(Importer importer) {
        importer.onStart((ImportContext)this);
        this.entries.forEach(o -> {
            if (o instanceof EntrySource) {
                importer.onEntry((ImportContext)this, (EntrySource)o);
            } else if (o instanceof ArchiveSource) {
                importer.onArchiveEntry((ImportContext)this, (ArchiveSource)o);
            } else {
                throw new IllegalStateException("Encountered unexpected mocked entry type: " + o.getClass().getCanonicalName());
            }
        });
        importer.onEnd((ImportContext)this);
    }

    public void setCurrentHierarchyId(String currentHierarchyId) {
        this.currentHierarchyId = currentHierarchyId;
    }

    public List<ErrorStub.Message> warnings() {
        return this.errorStub.getWarnings();
    }

    protected void finished(Description description) {
        try {
            this.expectNoMoreInteractions();
            this.verify();
        }
        finally {
            this.reset();
        }
    }

    private void checkMoreInteractionsAllowed() {
        if (this.noMoreInteractions) {
            throw new IllegalStateException("Expected no more interaction with the ImportContext.");
        }
    }

    private void expectNoMoreInteractions() {
        this.noMoreInteractions = true;
        this.importMapping.values().forEach(mapping -> {
            ((SimpleEntityImportMapping)Mockito.verify((Object)mapping, (VerificationMode)Mockito.atLeast((int)0))).getLocalId((String)Mockito.any());
            ((SimpleEntityImportMapping)Mockito.verify((Object)mapping, (VerificationMode)Mockito.atLeast((int)0))).getExportId(Mockito.any());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{mapping});
        });
    }

    private void reset() {
        this.errorStub.reset();
    }

    private void verify() {
        Matcher[] mappingMatchers = (Matcher[])this.assertedMappings.stream().map(Matchers::equalTo).toArray(Matcher[]::new);
        Set nonemptyMappings = this.importMapping.entrySet().stream().filter(entry -> ((SimpleEntityImportMapping)entry.getValue()).hasMappings()).map(Map.Entry::getKey).collect(Collectors.toSet());
        Assert.assertThat((String)"all mapping types were asserted", nonemptyMappings, (Matcher)Matchers.containsInAnyOrder((Matcher[])mappingMatchers));
    }

    public class Asserter {
        Asserter() {
        }

        public Asserter archiveEntry(Path path, IoConsumer<ArchiveSource> archiveSourceConsumer) throws IOException {
            ArchiveSource source = TestableImportContext.this.entries.stream().filter(o -> o instanceof ArchiveSource).map(ArchiveSource.class::cast).filter(archiveSource -> archiveSource.getPath().equals(path)).findAny().orElseThrow(FileNotFoundException::new);
            archiveSourceConsumer.accept((Object)source);
            return this;
        }

        public Asserter entry(Path path, IoConsumer<EntrySource> archiveSourceConsumer) throws IOException {
            EntrySource source = TestableImportContext.this.entries.stream().filter(o -> o instanceof EntrySource).map(EntrySource.class::cast).filter(archiveSource -> archiveSource.getPath().equals(path)).findAny().orElseThrow(FileNotFoundException::new);
            archiveSourceConsumer.accept((Object)source);
            return this;
        }

        public <T> Asserter mapping(MigrationEntityType<T> type, Consumer<EntityImportMapping<T>> mappingConsumer) {
            Assert.assertThat(TestableImportContext.this.importMapping.keySet(), (Matcher)Matchers.hasItem(type));
            EntityImportMapping mapping = (EntityImportMapping)TestableImportContext.this.importMapping.get(type);
            mappingConsumer.accept(mapping);
            TestableImportContext.this.assertedMappings.add(type);
            return this;
        }
    }

    public final class Mock
    extends EntriesMock<Mock> {
        public Mock archiveEntry(Path path, Consumer<EntriesMock> archive) {
            final LinkedList<EntrySource> entries = new LinkedList<EntrySource>();
            archive.accept(new EntriesMock(){

                @Override
                protected List<? super EntrySource> getEntries() {
                    return entries;
                }
            });
            this.getEntries().add(Mockito.spy((Object)new SimpleArchiveSource(path, entries)));
            return this;
        }

        public <T> Mock mapping(MigrationEntityType<T> type, Map<String, T> mappings) {
            mappings.forEach((k, v) -> {
                TestableImportContext.this.getEntityMapping(type).add((String)k, v);
                TestableImportContext.this.expect().mapping(type, (EntityImportMapping<T> mapping) -> ((EntityImportMapping)Mockito.verify((Object)mapping)).add(k, v));
            });
            return this;
        }

        public Mock throwingArchiveEntry(Path path) {
            this.getEntries().add(Mockito.spy((Object)new ThrowingArchiveSource(path)));
            return this;
        }

        @Override
        protected List<Object> getEntries() {
            return TestableImportContext.this.entries;
        }
    }

    public abstract class EntriesMock<T extends EntriesMock> {
        public T entry(Path path, String content) {
            return this.entry(path, content.getBytes(StandardCharsets.UTF_8));
        }

        public T entry(Path path, byte[] content) {
            this.getEntries().add((EntrySource)Mockito.spy((Object)new SimpleEntrySource(path, content)));
            return (T)this;
        }

        public T entry(EntrySource entry) {
            this.getEntries().add(entry);
            return (T)this;
        }

        public T throwingEntry(Path path) {
            this.getEntries().add((EntrySource)Mockito.spy((Object)new ThrowingEntrySource(path)));
            return (T)this;
        }

        protected abstract List<? super EntrySource> getEntries();
    }

    private static class ThrowingArchiveSource
    implements ArchiveSource {
        private final Path path;

        public ThrowingArchiveSource(Path path) {
            this.path = path;
        }

        public void extractToDisk(@Nonnull Path target, @Nonnull Predicate<String> filter) throws IOException {
            throw new IOException("expected exception");
        }

        @Nonnull
        public Path getPath() {
            return this.path;
        }

        public void read(@Nonnull IoConsumer<EntrySource> reader, @Nonnull Predicate<String> filter) throws IOException {
            throw new IOException("expected exception");
        }
    }

    private static class SimpleArchiveSource
    implements ArchiveSource {
        private final List<EntrySource> entries;
        private final Path path;

        SimpleArchiveSource(Path path, List<EntrySource> entries) {
            this.path = path;
            this.entries = entries;
        }

        public void extractToDisk(@Nonnull Path target, @Nonnull Predicate<String> filter) throws IOException {
            for (EntrySource entry : this.entries) {
                if (!filter.test(entry.getPath().toString())) continue;
                entry.extractToDisk(target.resolve(entry.getPath()));
            }
        }

        @Nonnull
        public Path getPath() {
            return this.path;
        }

        public void read(@Nonnull IoConsumer<EntrySource> reader, @Nonnull Predicate<String> filter) throws IOException {
            for (EntrySource entry : this.entries) {
                if (!filter.test(entry.getPath().toString())) continue;
                reader.accept((Object)entry);
            }
        }
    }

    private static class ThrowingEntrySource
    implements EntrySource {
        private final Path path;

        private ThrowingEntrySource(Path path) {
            this.path = path;
        }

        public <T> T apply(@Nonnull IoFunction<InputStream, T> reader) throws IOException {
            throw new IOException("expected exception");
        }

        public void extractToDisk(@Nonnull Path target) throws IOException {
            throw new IOException("expected exception");
        }

        @Nonnull
        public Path getPath() {
            return this.path;
        }

        public void read(@Nonnull IoConsumer<InputStream> reader) throws IOException {
            throw new IOException("expected exception");
        }
    }

    private static class SimpleEntrySource
    implements EntrySource {
        private final byte[] content;
        private final Path path;

        SimpleEntrySource(Path path, byte[] content) {
            this.content = content;
            this.path = path;
        }

        public <T> T apply(@Nonnull IoFunction<InputStream, T> reader) throws IOException {
            return (T)reader.apply((Object)new ByteArrayInputStream(this.content));
        }

        public void extractToDisk(@Nonnull Path target) throws IOException {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Files.copy(new ByteArrayInputStream(this.content), target, new CopyOption[0]);
        }

        @Nonnull
        public Path getPath() {
            return this.path;
        }

        public void read(@Nonnull IoConsumer<InputStream> reader) throws IOException {
            reader.accept((Object)new ByteArrayInputStream(this.content));
        }
    }
}

