/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.smtp;

import com.atlassian.bitbucket.async.WaitCondition;
import com.atlassian.bitbucket.smtp.MailTestUtils;
import com.atlassian.bitbucket.smtp.SmtpServer;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

class EmailCapturingWaitCondition
implements WaitCondition {
    private final SmtpServer smtpServer;
    private final Matcher<MimeMessage> emailMatcher;
    private MimeMessage matchingEmail;

    public EmailCapturingWaitCondition(SmtpServer smtpServer, Matcher<MimeMessage> emailMatcher) {
        this.smtpServer = smtpServer;
        this.emailMatcher = emailMatcher;
    }

    @Override
    public boolean test() {
        this.matchingEmail = this.findMatchingEmail();
        return this.matchingEmail != null;
    }

    @Override
    public void describeFailure(Description desc) throws MessagingException {
        desc.appendText("Unable to find ");
        this.emailMatcher.describeTo(desc);
        desc.appendText("\nReceived ");
        desc.appendText(MailTestUtils.asFormattedString(this.smtpServer.getReceivedEmails()));
    }

    public MimeMessage getMatchingEmail() {
        return this.matchingEmail;
    }

    private MimeMessage findMatchingEmail() {
        for (MimeMessage message : this.smtpServer.getReceivedEmails()) {
            if (!this.emailMatcher.matches((Object)message)) continue;
            return message;
        }
        return null;
    }
}

