/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hamcrest;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionRequest;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class PermissionRequestMatchers {
    private PermissionRequestMatchers() {
        throw new UnsupportedOperationException("Do not instantiate " + this.getClass().getSimpleName());
    }

    @Nonnull
    public static Matcher<PermissionRequest> globalPermissionRequest(@Nonnull Permission permission) {
        return PermissionRequestMatchers.permissionRequestWith(permission, null);
    }

    @Nonnull
    public static Matcher<PermissionRequest> idPermissionRequest(@Nonnull Permission permission, int id) {
        return PermissionRequestMatchers.permissionRequestWith(permission, id);
    }

    @Nonnull
    public static Matcher<PermissionRequest> permissionRequestWith(@Nonnull Permission permission, @Nullable Object resource) {
        return PermissionRequestMatchers.permissionRequestWith(permission, resource, null);
    }

    @Nonnull
    public static Matcher<PermissionRequest> permissionRequestWith(@Nonnull Permission permission, @Nullable Object resource, @Nullable ApplicationUser user) {
        return Matchers.allOf(PermissionRequestMatchers.withPermission(permission), PermissionRequestMatchers.withResource(resource), PermissionRequestMatchers.withUser(user));
    }

    @Nonnull
    public static Matcher<PermissionRequest> projectPermissionRequest(@Nonnull Permission permission, @Nonnull Project project) {
        return PermissionRequestMatchers.permissionRequestWith(permission, project);
    }

    @Nonnull
    public static Matcher<PermissionRequest> repositoryPermissionRequest(@Nonnull Permission permission, @Nonnull Repository repository) {
        return PermissionRequestMatchers.permissionRequestWith(permission, repository);
    }

    @Nonnull
    public static Matcher<PermissionRequest> withPermission(@Nonnull Permission permission) {
        return new FeatureMatcher<PermissionRequest, Permission>(Matchers.is((Object)permission), "permission", "permision"){

            protected Permission featureValueOf(PermissionRequest actual) {
                return actual.getPermission();
            }
        };
    }

    @Nonnull
    public static Matcher<PermissionRequest> withResource(@Nullable Object resource) {
        return PermissionRequestMatchers.withResourceThat((Matcher<Object>)Matchers.is((Object)resource));
    }

    @Nonnull
    public static Matcher<PermissionRequest> withResourceThat(@Nonnull Matcher<Object> resourceMatcher) {
        return new FeatureMatcher<PermissionRequest, Object>(resourceMatcher, "resource that", "resource"){

            protected Object featureValueOf(PermissionRequest actual) {
                return actual.getResource();
            }
        };
    }

    @Nonnull
    public static Matcher<PermissionRequest> withUser(@Nullable ApplicationUser user) {
        return PermissionRequestMatchers.withUserThat((Matcher<ApplicationUser>)Matchers.is((Object)user));
    }

    @Nonnull
    public static Matcher<PermissionRequest> withUserThat(@Nonnull Matcher<ApplicationUser> userMatcher) {
        return new FeatureMatcher<PermissionRequest, ApplicationUser>(userMatcher, "user that", "user"){

            protected ApplicationUser featureValueOf(PermissionRequest actual) {
                return actual.getUser();
            }
        };
    }
}

