/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.async;

import com.atlassian.bitbucket.async.WaitCondition;
import java.util.concurrent.Callable;
import org.hamcrest.Description;
import org.hamcrest.StringDescription;
import org.junit.Assert;

public class AsyncTestUtils {
    private AsyncTestUtils() {
    }

    public static void assertThreadInState(Thread.State state, Thread thread, long timeoutMs) {
        AsyncTestUtils.assertThreadInState(null, state, thread, timeoutMs);
    }

    public static void assertThreadInState(String message, Thread.State state, Thread thread, long timeoutMs) {
        long timeoutTimestamp = System.currentTimeMillis() + timeoutMs;
        while (System.currentTimeMillis() < timeoutTimestamp && thread.getState() != state) {
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        Assert.assertEquals((String)message, (Object)((Object)state), (Object)((Object)thread.getState()));
    }

    public static void assertThreadNotInState(Thread.State state, Thread thread, long timeoutMs) {
        AsyncTestUtils.assertThreadNotInState(null, state, thread, timeoutMs);
    }

    public static void assertThreadNotInState(String message, Thread.State state, Thread thread, long timeoutMs) {
        long timeoutTimestamp = System.currentTimeMillis() + timeoutMs;
        while (System.currentTimeMillis() < timeoutTimestamp && thread.getState() == state) {
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        Assert.assertNotEquals((String)message, (Object)((Object)state), (Object)((Object)thread.getState()));
    }

    public static void waitFor(WaitCondition waitCondition, long timeoutMs) {
        AsyncTestUtils.waitFor(waitCondition, timeoutMs, 50L);
    }

    public static void waitFor(WaitCondition waitCondition, long timeoutMs, long retryIntervalMs) {
        try {
            long startTime = System.currentTimeMillis();
            boolean conditionPassed = waitCondition.test();
            while (!conditionPassed && System.currentTimeMillis() - startTime < timeoutMs) {
                Thread.sleep(retryIntervalMs);
                conditionPassed = waitCondition.test();
            }
            if (!conditionPassed) {
                StringDescription desc = new StringDescription();
                waitCondition.describeFailure((Description)desc);
                throw new AssertionError((Object)desc.toString());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void assertWaitForChangedBy(int expectedChange, final Callable<Integer> valueProvider, Callable<Void> action, final long maxWaitTime) throws Exception {
        final int initialValue = valueProvider.call();
        final int expectedValue = initialValue + expectedChange;
        action.call();
        AsyncTestUtils.waitFor(new WaitCondition(){
            private int newValue;

            @Override
            public boolean test() throws Exception {
                this.newValue = (Integer)valueProvider.call();
                return this.newValue == expectedValue;
            }

            @Override
            public void describeFailure(Description description) throws Exception {
                description.appendText(String.format("Expected %d to have changed to %d but was %d after %dms", initialValue, expectedValue, this.newValue, maxWaitTime));
            }
        }, maxWaitTime);
    }
}

