/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket;

import com.atlassian.bitbucket.security.AuthorizedAnnotationHelper;
import com.atlassian.stash.internal.annotation.Secured;
import com.atlassian.stash.internal.annotation.Unsecured;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PostFilter;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PreFilter;
import org.springframework.util.ReflectionUtils;

public abstract class AbstractServiceTest
extends Assert {
    private final Logger log;
    private final Class<?> serviceClass;
    private final Class<?>[] serviceInterfaces;

    protected AbstractServiceTest(Class<?> serviceClass, Class<?> ... serviceInterfaces) {
        this.serviceClass = serviceClass;
        this.serviceInterfaces = serviceInterfaces;
        this.log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    }

    @Test
    public void testServiceMethodsCheckPermissions() throws Exception {
        if (AnnotationUtils.findAnnotation(this.serviceClass, PreAuthorize.class) != null) {
            return;
        }
        ArrayList<Method> unpermissioned = new ArrayList<Method>();
        for (Class<?> serviceInterface : this.serviceInterfaces) {
            for (Method method : serviceInterface.getMethods()) {
                Method method2 = this.serviceClass.getMethod(method.getName(), method.getParameterTypes());
                Secured secured = (Secured)AnnotationUtils.findAnnotation((Method)method2, Secured.class);
                if (secured != null) {
                    if (!StringUtils.isBlank((CharSequence)secured.value())) continue;
                    this.log.warn("{}: @Secured annotation is not documented", (Object)method2);
                    continue;
                }
                Unsecured unsecured = (Unsecured)AnnotationUtils.findAnnotation((Method)method2, Unsecured.class);
                if (unsecured != null) {
                    if (!StringUtils.isBlank((CharSequence)unsecured.value())) continue;
                    this.log.warn("{}: @Unsecured annotation is not documented", (Object)method2);
                    continue;
                }
                if (AnnotationUtils.findAnnotation((Method)method2, PreAuthorize.class) != null || AnnotationUtils.findAnnotation((Method)method2, PostAuthorize.class) != null || AnnotationUtils.findAnnotation((Method)method2, PreFilter.class) != null || AnnotationUtils.findAnnotation((Method)method2, PostFilter.class) != null) continue;
                unpermissioned.add(method2);
            }
        }
        if (!unpermissioned.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.serviceClass.getSimpleName()).append(" contains ").append(unpermissioned.size()).append(" method");
            if (unpermissioned.size() > 1) {
                builder.append("s");
            }
            builder.append(" to which permission checks have not been applied:");
            for (Method method : unpermissioned) {
                builder.append("\n").append(method.getReturnType().getSimpleName()).append(" ").append(method.getName()).append("(");
                boolean first = true;
                for (GenericDeclaration genericDeclaration : method.getParameterTypes()) {
                    if (first) {
                        first = false;
                    } else {
                        builder.append(", ");
                    }
                    builder.append(((Class)genericDeclaration).getSimpleName());
                }
                builder.append(")");
            }
            AbstractServiceTest.fail((String)builder.toString());
        }
    }

    @Test
    public void testPrePostAuthorize() throws Throwable {
        new AuthorizedAnnotationHelper(this.serviceClass).testAuthorizedMethods();
    }

    protected void setPageLimit(Object instance, String fieldName, int value) throws Exception {
        Field field = ReflectionUtils.findField(instance.getClass(), (String)fieldName);
        ReflectionUtils.makeAccessible((Field)field);
        field.set(instance, value);
    }
}

