/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import org.junit.Assert;

public class JsonTestUtils {
    public static void assertJsonContains(String json, String key, String value) {
        JsonElement element = JsonTestUtils.find(json, key);
        Assert.assertNotNull((String)("element '" + key + "' not found in JSON " + json), (Object)element);
        Assert.assertTrue((boolean)element.isJsonPrimitive());
        Assert.assertEquals((String)("value for " + key + " does not match"), (Object)value, (Object)element.getAsString());
    }

    public static void assertJsonNotContains(String json, String key) {
        JsonElement element = JsonTestUtils.find(json, key);
        Assert.assertNull((String)("'" + key + "' should not be present in JSON " + json), (Object)element);
    }

    private static JsonElement find(String json, String key) {
        JsonElement element = new JsonParser().parse(json);
        for (String part : key.split("\\.")) {
            if (element == null) {
                return null;
            }
            element = element.getAsJsonObject().get(part);
        }
        return element;
    }
}

