/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.setup;

import com.atlassian.bitbucket.setup.MockExternalServerHandler;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;

public class DefaultMockExternalServerHandler
implements MockExternalServerHandler,
HttpHandler {
    private static final String GET_COUNTRIES_URL = "/test/1.0/public/country/all";
    private static final String USER_EXISTS_URL = "/test/profile/rest/user";
    private static final String SIGNUP_URL = "/test/profile/rest/signUp";
    private static final String SIGNIN_URL = "/test/id/rest/login";
    private static final String GENERATE_LICENSE_URL = "/test/1.0/public/license/createEvaluation";
    private Set<String> existingEmails = new HashSet<String>();
    private ArrayList<String> countries = new ArrayList();
    private Map<String, String> signInTokens = new HashMap<String, String>();
    private Map<String, String> signUpTokens = new HashMap<String, String>();
    private Map<String, String> licenseKeys = new HashMap<String, String>();
    private Map<String, Integer> responseCodes = new HashMap<String, Integer>();
    private Map<String, String> formErrorResponses = new HashMap<String, String>();
    private String genericErrorMessage = "There was an error";
    private String genericErrorResponse = String.format("{\"error\":\"%s\"}", this.genericErrorMessage);

    public String getGenericErrorMessage() {
        return this.genericErrorMessage;
    }

    @Override
    public void returnCountryCode(String ... countryCodes) {
        for (String country : countryCodes) {
            this.countries.add(country);
        }
    }

    @Override
    public void whenLicenseRequestReturnLicenseKey(String token, String licenseKey) {
        this.licenseKeys.put(token, licenseKey);
    }

    @Override
    public void whenUserCheckReturnExists(String email) {
        this.existingEmails.add(email);
    }

    @Override
    public void whenSignUpReturnToken(String email, String token) {
        this.signUpTokens.put(email, token);
    }

    @Override
    public void whenSignInReturnToken(String email, String token) {
        this.signInTokens.put(email, token);
    }

    private boolean userExists(String email) {
        return this.existingEmails.contains(email);
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        String requestPath = httpExchange.getRequestURI().getPath();
        String requestAddress = (String)httpExchange.getRequestHeaders().get("Origin").get(0);
        StringBuilder responseBuffer = new StringBuilder();
        Headers headers = httpExchange.getResponseHeaders();
        this.addHeaders(headers, requestAddress);
        int httpResponseCode = this.responseCodes.containsKey(requestPath) ? this.responseCodes.get(requestPath) : 200;
        switch (httpExchange.getRequestMethod()) {
            case "GET": {
                if (requestPath.startsWith(GET_COUNTRIES_URL)) {
                    this.handleCountriesRequest(responseBuffer);
                    break;
                }
                if (!requestPath.startsWith(USER_EXISTS_URL)) break;
                String user = requestPath.replace("/test/profile/rest/user/", "");
                this.handleUserExistsRequests(responseBuffer, user);
                break;
            }
            case "POST": {
                InputStreamReader isr = new InputStreamReader(httpExchange.getRequestBody(), "utf-8");
                BufferedReader br = new BufferedReader(isr);
                String value = br.readLine();
                JSONObject data = JSONObject.fromObject((Object)value);
                if (requestPath.startsWith(SIGNUP_URL)) {
                    this.handleSignUpRequest(responseBuffer, data);
                    break;
                }
                if (requestPath.startsWith(SIGNIN_URL)) {
                    this.handleSignInRequest(responseBuffer, data);
                    break;
                }
                if (!requestPath.startsWith(GENERATE_LICENSE_URL)) break;
                String xsrfToken = (String)httpExchange.getRequestHeaders().get("Atl-xsrf-token").get(0);
                this.handleLicenseRequest(responseBuffer, headers, xsrfToken);
            }
        }
        String response = responseBuffer.toString();
        if (response.contains(this.genericErrorResponse)) {
            httpResponseCode = 400;
        }
        httpExchange.sendResponseHeaders(httpResponseCode, response.length());
        try (OutputStream os = httpExchange.getResponseBody();){
            os.write(response.getBytes("UTF-8"));
            os.flush();
        }
        httpExchange.close();
    }

    private void addHeaders(Headers headers, String requestAddress) {
        headers.add("Access-Control-Allow-Origin", requestAddress);
        headers.add("Access-Control-Allow-Credentials", "true");
        headers.add("Access-Control-Allow-Methods", "PATCH, PUT, DELETE, OPTIONS, HEAD, GET, POST");
        headers.add("Allow", "GET, HEAD, POST, PUT, DELETE, TRACE, OPTIONS, PATCH");
        headers.add("Access-Control-Max-Age", "1800");
        headers.add("Access-Control-Allow-Headers", "Atl-Xsrf-Token,X-Requested-With,Origin,Authentication,Accept,Content-Type,ATL-XSRF-Token,__ATL_USER,X-CSRF-TOKEN");
        headers.add("Vary", "Origin");
        headers.add("Access-Control-Expose-Headers", "X-CSRF-HEADER, X-CSRF-PARAM, X-CSRF-TOKEN");
        headers.add("Content-Type", "application/json;charset=UTF-8");
    }

    private void handleLicenseRequest(StringBuilder responseBuffer, Headers headers, String token) {
        String response;
        if (this.licenseKeys.containsKey(token)) {
            String licenseKey = this.licenseKeys.get(token);
            response = "{\"licenseKey\":\"" + licenseKey + "\"}";
        } else {
            response = this.genericErrorResponse;
        }
        responseBuffer.append(response);
    }

    private void handleSignInRequest(StringBuilder responseBuffer, JSONObject data) {
        String response;
        String email = data.getString("username");
        if (this.signInTokens.containsKey(email)) {
            String xsrfToken = this.signInTokens.get(email);
            response = "{\"username\":\"" + email + "\", \"xsrfToken\":\"" + xsrfToken + "\"}";
        } else {
            response = this.genericErrorResponse;
        }
        responseBuffer.append(response);
    }

    private void handleSignUpRequest(StringBuilder responseBuffer, JSONObject data) {
        String response;
        String email = data.getString("email");
        if (this.signUpTokens.keySet().contains(email)) {
            String xsrfToken = this.signUpTokens.get(email);
            response = "{\"username\":\"" + email + "\", \"xsrfToken\":\"" + xsrfToken + "\"}";
        } else {
            response = this.genericErrorResponse;
        }
        responseBuffer.append(response);
    }

    private void handleUserExistsRequests(StringBuilder responseBuffer, String user) {
        responseBuffer.append("{\"exists\":" + this.userExists(user) + ",\"contactDetails\":null,\"organisationDetails\":null}");
    }

    public void handleCountriesRequest(StringBuilder responseBuffer) throws IOException {
        responseBuffer.append("{\"countryList\":[");
        for (String country : this.countries) {
            responseBuffer.append("{\"displayName\":\"" + country + "\", \"countryIsoCode\":\"" + country + "\"}");
            if (this.countries.lastIndexOf(country) >= this.countries.size() - 1) continue;
            responseBuffer.append(", ");
        }
        responseBuffer.append("]}");
    }
}

