/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.server;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.security.PublicKey;
import javax.annotation.Nonnull;

public class SshCredentials {
    private final PublicKey publicKey;
    private final String username;

    public SshCredentials(@Nonnull String username, @Nonnull PublicKey publicKey) {
        this.publicKey = (PublicKey)Preconditions.checkNotNull((Object)publicKey, (Object)"key");
        this.username = (String)Preconditions.checkNotNull((Object)username, (Object)"username");
    }

    @Nonnull
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Nonnull
    public String getUsername() {
        return this.username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SshCredentials)) {
            return false;
        }
        SshCredentials that = (SshCredentials)o;
        return Objects.equal((Object)this.publicKey, (Object)that.publicKey) && Objects.equal((Object)this.username, (Object)that.username);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.publicKey, this.username});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("username", (Object)this.username).add("publicKey", (Object)this.publicKey).toString();
    }
}

