/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.server;

import com.atlassian.bitbucket.auth.SshAuthenticationContext;
import com.atlassian.bitbucket.auth.SshAuthenticationHandler;
import com.atlassian.bitbucket.internal.ssh.server.SshKeyDetails;
import com.atlassian.bitbucket.ssh.SshConfigurationService;
import com.atlassian.bitbucket.ssh.SshKey;
import com.atlassian.bitbucket.ssh.SshKeyService;
import com.atlassian.bitbucket.user.AbstractApplicationUserVisitor;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUserVisitor;
import com.atlassian.bitbucket.user.DetailedUser;
import com.atlassian.bitbucket.user.ServiceUser;
import javax.annotation.Nonnull;

public class DefaultSshAuthenticationHandler
implements SshAuthenticationHandler {
    private final SshKeyService sshKeyService;
    private final SshConfigurationService sshConfigurationService;

    public DefaultSshAuthenticationHandler(SshKeyService sshKeyService, SshConfigurationService sshConfigurationService) {
        this.sshKeyService = sshKeyService;
        this.sshConfigurationService = sshConfigurationService;
    }

    public ApplicationUser authenticate(@Nonnull SshAuthenticationContext authenticationContext) {
        ApplicationUser user;
        SshKey sshKey = this.sshKeyService.getByPublicKey(authenticationContext.getPublicKey());
        ApplicationUser applicationUser = user = sshKey == null ? null : sshKey.getUser();
        if (user == null || this.sshConfigurationService.getConfiguration().isAccessKeysEnabled()) {
            return user;
        }
        if ((user = (ApplicationUser)user.accept((ApplicationUserVisitor)new AbstractApplicationUserVisitor<ApplicationUser>(){

            public ApplicationUser visit(@Nonnull ApplicationUser user) {
                return user;
            }

            public ApplicationUser visit(@Nonnull DetailedUser user) {
                return user;
            }

            public ApplicationUser visit(@Nonnull ServiceUser user) {
                return "access-key".equals(user.getLabel()) ? null : user;
            }
        })) != null) {
            new SshKeyDetails(Integer.toString(sshKey.getId()), sshKey.getLabel()).putInMDC();
        }
        return user;
    }
}

