/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.scm;

import com.atlassian.bitbucket.internal.ssh.server.DefaultingExitCodeCallback;
import com.atlassian.bitbucket.scm.ScmRequest;
import com.atlassian.bitbucket.scm.ScmRequestCheckService;
import com.atlassian.bitbucket.scm.ssh.SshScmRequest;
import com.atlassian.bitbucket.ssh.command.SshCommand;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScmRequestSshCommand
implements SshCommand {
    private static final Logger log = LoggerFactory.getLogger(ScmRequestSshCommand.class);
    private final SshScmRequest scmRequest;
    private final DefaultingExitCodeCallback exitCodeCallback;
    private final ScmRequestCheckService scmRequestCheckService;

    public ScmRequestSshCommand(SshScmRequest scmRequest, DefaultingExitCodeCallback exitCodeCallback, ScmRequestCheckService scmRequestCheckService) {
        this.scmRequest = scmRequest;
        this.exitCodeCallback = exitCodeCallback;
        this.scmRequestCheckService = scmRequestCheckService;
    }

    public void cancel() {
        this.scmRequest.cancel();
    }

    public int run() throws IOException {
        if (this.scmRequestCheckService.checkActionAllowed((ScmRequest)this.scmRequest)) {
            log.trace("{}: Request has passed checking and will be processed", (Object)this.scmRequest);
            this.scmRequest.handleRequest();
        } else {
            log.debug("{}: Request has failed a check and will not be processed", (Object)this.scmRequest);
        }
        return this.exitCodeCallback.getExitCode();
    }
}

