/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.condition;

import com.atlassian.bitbucket.internal.ssh.server.SshServer;
import com.atlassian.bitbucket.internal.ssh.server.SshServerState;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Locale;
import java.util.Map;

public class ServerInStateCondition
implements Condition {
    static final String PARAM_STATE = "state";
    private final SshServer sshServer;
    private SshServerState state;

    public ServerInStateCondition(SshServer sshServer) {
        this.sshServer = sshServer;
    }

    public void init(Map<String, String> params) throws PluginParseException {
        String stateName = params.get(PARAM_STATE);
        if (stateName == null) {
            throw new PluginParseException(String.format("%1$s must have a '%2$s' param matching a %3$s value!\nFor example: <param name=\"%2$s\">%4$s</param>", new Object[]{ServerInStateCondition.class.getSimpleName(), PARAM_STATE, SshServerState.class.getSimpleName(), SshServerState.RUNNING}));
        }
        try {
            this.state = SshServerState.valueOf(stateName.trim().toUpperCase(Locale.US));
        }
        catch (IllegalArgumentException e) {
            throw new PluginParseException(String.format("'%s' is not a valid value for the '%s' param. Must match a %s value.", stateName, PARAM_STATE, SshServerState.class.getSimpleName()));
        }
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        return this.sshServer.getStatus().getState() == this.state;
    }
}

