/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.key.ssh.condition;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.ssh.SshAccessKeyService;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;

public class ProjectHasSshAccessKeyCondition
implements Condition {
    private final SshAccessKeyService accessKeyService;
    private boolean negate;

    public ProjectHasSshAccessKeyCondition(SshAccessKeyService accessKeyService) {
        this.accessKeyService = accessKeyService;
    }

    public void init(Map<String, String> params) throws PluginParseException {
        this.negate = Boolean.valueOf(params.get("negate"));
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        Project project = (Project)context.get("project");
        if (project == null) {
            project = this.findProject(context, project);
        }
        if (project == null) {
            return false;
        }
        return this.negate != this.accessKeyService.existsForProject(project);
    }

    private Project findProject(Map<String, Object> context, Project project) {
        Repository repository = (Repository)context.get("repository");
        if (repository != null) {
            project = repository.getProject();
        }
        return project;
    }
}

