/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.ssh;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.google.common.base.Preconditions;
import java.util.EnumSet;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SetSshAccessKeyRequest {
    private final Integer keyId;
    private final String keyLabel;
    private final String keyText;
    private final Permission permission;
    private final Project project;
    private final Repository repository;

    private SetSshAccessKeyRequest(Builder builder) {
        this.keyId = builder.keyId;
        this.keyLabel = builder.keyLabel;
        this.keyText = builder.keyText;
        this.permission = builder.permission;
        this.project = builder.project;
        this.repository = builder.repository;
    }

    public Integer getKeyId() {
        return this.keyId;
    }

    public String getKeyLabel() {
        return this.keyLabel;
    }

    public String getKeyText() {
        return this.keyText;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public Project getProject() {
        return this.project;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetSshAccessKeyRequest that = (SetSshAccessKeyRequest)o;
        return Objects.equals(this.keyLabel, that.keyLabel) && Objects.equals(this.keyText, that.keyText) && Objects.equals(this.permission, that.permission) && Objects.equals(this.project, that.project) && Objects.equals(this.repository, that.repository);
    }

    public int hashCode() {
        return Objects.hash(this.keyLabel, this.keyText, this.permission, this.project, this.repository);
    }

    public String toString() {
        return "SetAccessRequest{keyId=" + this.keyId + ", keyLabel='" + this.keyLabel + '\'' + ", keyText='" + this.keyText + '\'' + ", permission=" + this.permission + ", project=" + this.project + ", repository=" + this.repository + '}';
    }

    public static class Builder {
        private Integer keyId;
        private String keyLabel;
        private String keyText;
        private Permission permission;
        private Project project;
        private Repository repository;

        public SetSshAccessKeyRequest build() {
            Preconditions.checkState((this.project == null && this.repository != null || this.project != null && this.repository == null ? 1 : 0) != 0, (Object)"either a project or a repository must be provided (not both)");
            Preconditions.checkState((this.permission == null || !this.permission.isGlobal() ? 1 : 0) != 0, (Object)"only resource permissions may be specified");
            return new SetSshAccessKeyRequest(this);
        }

        public Builder key(int id) {
            this.keyId = id;
            return this;
        }

        public Builder key(String keyText, String keyLabel) {
            this.keyLabel = keyLabel;
            this.keyText = keyText;
            return this;
        }

        public Builder projectAccess(@Nonnull Project project, @Nonnull Permission permission) {
            Preconditions.checkNotNull((Object)project, (Object)"project");
            Preconditions.checkNotNull((Object)project.getId(), (Object)"project.id");
            this.permission = this.checkPermission("not a valid project permission", permission, Permission.PROJECT_READ, Permission.PROJECT_WRITE);
            this.project = project;
            return this;
        }

        public Builder repositoryAccess(@Nonnull Repository repository, @Nonnull Permission permission) {
            Preconditions.checkNotNull((Object)repository, (Object)"repository");
            Preconditions.checkNotNull((Object)repository.getId(), (Object)"repository.id");
            this.permission = this.checkPermission("not a valid repository permission", permission, Permission.REPO_READ, Permission.REPO_WRITE);
            this.repository = repository;
            return this;
        }

        private Permission checkPermission(String message, Permission actualPermission, Permission allowedPermission, Permission ... moreAllowedPermissions) {
            Preconditions.checkArgument((boolean)EnumSet.of(allowedPermission, moreAllowedPermissions).contains(Preconditions.checkNotNull((Object)actualPermission, (Object)"permission")), (Object)message);
            return actualPermission;
        }
    }
}

