/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.util;

import com.atlassian.bitbucket.util.FilteredPageImpl;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageProvider;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class InternalPageUtils {
    private static final long FETCH_GROWTH_FACTOR = 4L;

    @Nonnull
    public static <T> Page<T> filterPages(PageProvider<T> provider, Predicate<? super T> predicate, PageRequest request, int fetchCeiling) {
        Page internalPage;
        Preconditions.checkArgument((fetchCeiling > 0 ? 1 : 0) != 0, (Object)"fetchCeiling must be > 0");
        fetchCeiling = Math.min(fetchCeiling, 0x100000);
        int internalStart = request.getStart();
        int internalLimit = request.getLimit() * 2;
        int pageLimit = request.getLimit() + 1;
        TreeMap results = new TreeMap();
        block0: do {
            PageRequestImpl internalRequest = new PageRequestImpl(internalStart, internalLimit);
            internalPage = provider.get((PageRequest)internalRequest);
            for (Map.Entry entry : internalPage.getOrdinalIndexedValues().entrySet()) {
                if (!predicate.test(entry.getValue())) continue;
                results.put(entry.getKey(), entry.getValue());
                if (results.size() != pageLimit) continue;
                break block0;
            }
            internalStart += internalLimit;
            internalLimit = Math.min(fetchCeiling, Ints.saturatedCast((long)((long)internalLimit * 4L)));
        } while (results.size() < pageLimit && !internalPage.getIsLastPage());
        int size = results.size();
        boolean lastPage = size < pageLimit;
        int pageSize = lastPage ? size : request.getLimit();
        return new FilteredPageImpl(request, pageSize, results, lastPage);
    }
}

