/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.stash.internal.user.DefaultPermissionGraph;
import com.atlassian.stash.internal.user.EffectivePermissionGraphFactoryBase;
import com.atlassian.stash.internal.user.EffectivePermissionsProviderTracker;
import com.atlassian.stash.internal.user.InternalUserUtils;
import com.atlassian.stash.internal.user.IterablePermissionGraph;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;

public class ExternalUserPermissionGraphFactory
extends EffectivePermissionGraphFactoryBase {
    @Autowired
    public ExternalUserPermissionGraphFactory(EffectivePermissionsProviderTracker permissionsProviderTracker) {
        super(permissionsProviderTracker);
    }

    @Nonnull
    public IterablePermissionGraph createGraph(@Nonnull ApplicationUser user) {
        Preconditions.checkArgument((!InternalUserUtils.isInternalUser(user) ? 1 : 0) != 0, (Object)"This factory can only create graphs for external user");
        DefaultPermissionGraph.Builder builder = new DefaultPermissionGraph.Builder().addEffectivePermissions(this.getEffectivePermissions(user));
        if (user.getType() == UserType.SERVICE) {
            builder = builder.add(Permission.LICENSED_USER, null);
        }
        return builder.build();
    }
}

