/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.permission.EffectiveGlobalPermission;
import com.atlassian.bitbucket.permission.EffectivePermission;
import com.atlassian.bitbucket.permission.EffectivePermissionVisitor;
import com.atlassian.bitbucket.permission.EffectiveProjectPermission;
import com.atlassian.bitbucket.permission.EffectiveRepositoryPermission;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.SimpleEffectiveGlobalPermission;
import com.atlassian.bitbucket.permission.SimpleEffectiveProjectPermission;
import com.atlassian.bitbucket.permission.SimpleEffectiveRepositoryPermission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.fugue.Pair;
import com.atlassian.stash.internal.user.InternalGlobalPermission;
import com.atlassian.stash.internal.user.InternalGrantedPermission;
import com.atlassian.stash.internal.user.InternalGrantedPermissionVisitor;
import com.atlassian.stash.internal.user.InternalProjectPermission;
import com.atlassian.stash.internal.user.InternalRepositoryPermission;
import com.atlassian.stash.internal.user.IterablePermissionGraph;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Longs;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class DefaultPermissionGraph
implements IterablePermissionGraph,
Externalizable {
    private static final Encoding ENCODING = new Encoding();
    private static final DefaultPermissionGraph NO_PERMS = new DefaultPermissionGraph(new long[0]);
    private long[] values;

    public DefaultPermissionGraph() {
    }

    private DefaultPermissionGraph(long[] values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass() && Arrays.equals(this.values, ((DefaultPermissionGraph)o).values);
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public boolean isGranted(@Nonnull Permission permission, @Nullable Object resource) {
        if (this.values.length == 0) {
            return false;
        }
        Matcher matcher = ENCODING.createMatcher(permission, resource);
        for (long value : this.values) {
            if (!matcher.matches(value)) continue;
            return true;
        }
        return false;
    }

    public int getSize() {
        return this.values.length;
    }

    public Iterator<EffectivePermission> iterator() {
        return Chainable.chain((Iterable)Longs.asList((long[])this.values)).transform(Encoding.TO_EFFECTIVE_PERMISSION).iterator();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        this.values = new long[size];
        for (int i = 0; i < size; ++i) {
            this.values[i] = in.readLong();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultPermissionGraph{values={");
        if (this.values != null) {
            for (int i = 0; i < this.values.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(ENCODING.toString(this.values[i]));
            }
        }
        sb.append("}}");
        return sb.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.values.length);
        for (long value : this.values) {
            out.writeLong(value);
        }
    }

    static interface Matcher {
        public boolean matches(long var1);
    }

    static class Encoding {
        private static final long FLAG_PERM_GLOBAL = 0x100000000000000L;
        private static final long FLAG_PERM_PROJECT = 0x200000000000000L;
        private static final long FLAG_PERM_REPO = 0x400000000000000L;
        private static final int[] ENCODED_PERMISSIONS;
        private static final Map<Integer, Permission> DECODED_PERMISSIONS;
        private static final Function<Long, EffectivePermission> TO_EFFECTIVE_PERMISSION;

        Encoding() {
        }

        public String toString(long encoded) {
            String permissionString = Encoding.decodePermission(encoded).toString();
            if ((encoded & 0x100000000000000L) != 0L) {
                return permissionString;
            }
            return permissionString + ": " + Encoding.decodeResourceId(encoded);
        }

        public long encode(@Nonnull Permission permission, @Nullable Integer resourceId) {
            Preconditions.checkArgument((resourceId == null || resourceId > 0 ? 1 : 0) != 0, (Object)"resourceId must be null or greater than 0");
            return Encoding.getCategory(permission) | Encoding.encodeResourceId(resourceId) | (long)Encoding.encodeEffectivePermissionInt(permission);
        }

        @Nonnull
        public Matcher createMatcher(@Nonnull Permission permission, @Nullable Object resource) {
            Preconditions.checkArgument((resource == null || resource instanceof Project || resource instanceof Repository ? 1 : 0) != 0, (Object)"Resource must either be null or be a Project or Repository");
            final int permissionInt = Encoding.encodePermissionInt(permission);
            final int projectId = this.getProjectId(resource);
            final int repositoryId = this.getRepositoryId(resource);
            return new Matcher(){

                @Override
                public boolean matches(long encoded) {
                    if ((encoded & (long)permissionInt) == 0L) {
                        return false;
                    }
                    if (projectId == 0 && repositoryId == 0) {
                        return true;
                    }
                    if ((encoded & 0x100000000000000L) != 0L) {
                        return true;
                    }
                    int encodedId = Encoding.decodeResourceId(encoded);
                    return (encoded & 0x200000000000000L) != 0L && projectId != 0 && (encodedId == 0 || projectId == encodedId) || (encoded & 0x400000000000000L) != 0L && repositoryId != 0 && (encodedId == 0 || repositoryId == encodedId);
                }
            };
        }

        private int getProjectId(Object resource) {
            if (resource instanceof Project) {
                return ((Project)resource).getId();
            }
            if (resource instanceof Repository) {
                return ((Repository)resource).getProject().getId();
            }
            return 0;
        }

        private int getRepositoryId(Object resource) {
            return resource instanceof Repository ? ((Repository)resource).getId() : 0;
        }

        private static long getCategory(Permission permission) {
            if (permission.isGlobal()) {
                return 0x100000000000000L;
            }
            if (permission.isResource(Project.class)) {
                return 0x200000000000000L;
            }
            if (permission.isResource(Repository.class)) {
                return 0x400000000000000L;
            }
            throw new IllegalArgumentException("Unsupported permission type " + permission);
        }

        @VisibleForTesting
        static int decodeResourceId(long encoded) {
            return (int)(encoded >> 24);
        }

        private static boolean isSameCategoryAndResourceId(long encoded1, long encoded2) {
            return (encoded1 & 0xFFFFFFFFFF000000L) == (encoded2 & 0xFFFFFFFFFF000000L);
        }

        private static long encodeResourceId(Integer resourceId) {
            return resourceId != null ? (long)resourceId.intValue() << 24 : 0L;
        }

        @VisibleForTesting
        static Permission decodePermission(long encoded) {
            int permission = Encoding.unmaskPermissionBitsInt(encoded);
            return DECODED_PERMISSIONS.get(permission);
        }

        private static int unmaskPermissionBitsInt(long encoded) {
            return 0xFFFFFF & (int)encoded;
        }

        private static long unmaskPermissionBits(long encoded) {
            return 0xFFFFFFL & (long)((int)encoded);
        }

        private static int encodePermissionInt(Permission permission) {
            return 1 << permission.getId();
        }

        private static int encodeEffectivePermissionInt(Permission permission) {
            return ENCODED_PERMISSIONS[permission.ordinal()];
        }

        private long getProjectMatcher(int projectId) {
            return 0x200000000000000L | Encoding.encodeResourceId(projectId);
        }

        private static boolean isResourcePermission(long encoding) {
            return (encoding & 0x100000000000000L) == 0L;
        }

        static {
            TO_EFFECTIVE_PERMISSION = input -> {
                long encoded = input;
                Permission permission = Encoding.decodePermission(encoded);
                if ((encoded & 0x100000000000000L) != 0L) {
                    return new SimpleEffectiveGlobalPermission(permission);
                }
                int resourceId = Encoding.decodeResourceId(encoded);
                if ((encoded & 0x200000000000000L) != 0L) {
                    return new SimpleEffectiveProjectPermission(resourceId, permission);
                }
                return new SimpleEffectiveRepositoryPermission(resourceId, permission);
            };
            ENCODED_PERMISSIONS = new int[Permission.values().length];
            DECODED_PERMISSIONS = Maps.newHashMap();
            for (Permission permission : Permission.values()) {
                int value = Encoding.encodePermissionInt(permission);
                for (Permission inherited : permission.getInheritedPermissions()) {
                    value |= Encoding.encodePermissionInt(inherited);
                }
                Encoding.ENCODED_PERMISSIONS[permission.ordinal()] = value;
                DECODED_PERMISSIONS.put(value, permission);
            }
        }
    }

    public static class Builder
    implements InternalGrantedPermissionVisitor,
    EffectivePermissionVisitor<Void> {
        private static final long NO_GLOBAL_PERMS = 0x100000000000000L;
        private static final Predicate<Long> IS_RESOURCE_PERM = new Predicate<Long>(){

            public boolean apply(Long value) {
                return Encoding.isResourcePermission(value);
            }
        };
        private List<Long> values = Lists.newArrayList();

        public Builder add(@Nonnull InternalGrantedPermission grantedPermission) {
            grantedPermission.accept((InternalGrantedPermissionVisitor)this);
            return this;
        }

        public Builder add(@Nonnull Permission permission, @Nullable Integer resourceId) {
            this.values.add(ENCODING.encode(permission, resourceId));
            return this;
        }

        public Builder add(@Nonnull EffectivePermission permission) {
            permission.accept((EffectivePermissionVisitor)this);
            return this;
        }

        public Builder addGraph(@Nonnull DefaultPermissionGraph permissions) {
            for (long value : permissions.values) {
                this.values.add(value);
            }
            return this;
        }

        public Builder addInternalPermissions(@Nonnull Iterable<? extends InternalGrantedPermission> permissions) {
            for (InternalGrantedPermission internalGrantedPermission : permissions) {
                this.add(internalGrantedPermission);
            }
            return this;
        }

        public Builder addEffectivePermissions(@Nonnull Iterable<? extends EffectivePermission> permissions) {
            for (EffectivePermission effectivePermission : permissions) {
                this.add(effectivePermission);
            }
            return this;
        }

        public DefaultPermissionGraph build() {
            if (this.values.isEmpty()) {
                return NO_PERMS;
            }
            Pair<Long, List<Long>> permsByScope = this.partitionPermsByScope(Lists.newArrayList(this.values));
            long globalPermissions = (Long)permsByScope.left();
            List<Long> resourcePerms = this.impliesProjectAdmin(globalPermissions) ? Collections.emptyList() : this.reduceResourcePerms(globalPermissions, (List)permsByScope.right());
            long[] v = new long[resourcePerms.size() + (this.isNonEmpty(globalPermissions) ? 1 : 0)];
            int index = 0;
            if (this.isNonEmpty(globalPermissions)) {
                v[index++] = globalPermissions;
            }
            for (Long value : resourcePerms) {
                v[index++] = value;
            }
            return new DefaultPermissionGraph(v);
        }

        public Builder clearAllForProject(Project project) {
            return this.clearAllForProject(((Project)Preconditions.checkNotNull((Object)project, (Object)"project")).getId());
        }

        public Builder clearAllForProject(int projectId) {
            long projectMatcher = ENCODING.getProjectMatcher(projectId);
            Iterator<Long> it = this.values.iterator();
            while (it.hasNext()) {
                long value = it.next();
                if ((value & projectMatcher) != projectMatcher || Encoding.decodeResourceId(value) != projectId) continue;
                it.remove();
                break;
            }
            return this;
        }

        public void visit(@Nonnull InternalGlobalPermission globalPermission) {
            this.values.add(ENCODING.encode(globalPermission.getPermission(), null));
        }

        public void visit(@Nonnull InternalProjectPermission projectPermission) {
            this.values.add(ENCODING.encode(projectPermission.getPermission(), projectPermission.getProject().getId()));
        }

        public void visit(@Nonnull InternalRepositoryPermission repositoryPermission) {
            this.values.add(ENCODING.encode(repositoryPermission.getPermission(), repositoryPermission.getRepository().getId()));
            this.values.add(ENCODING.encode(Permission.PROJECT_VIEW, repositoryPermission.getRepository().getProject().getId()));
        }

        public Void visit(@Nonnull EffectiveGlobalPermission globalPermission) {
            this.values.add(ENCODING.encode(globalPermission.getPermission(), null));
            return null;
        }

        public Void visit(@Nonnull EffectiveProjectPermission projectPermission) {
            this.values.add(ENCODING.encode(projectPermission.getPermission(), projectPermission.getProjectId()));
            return null;
        }

        public Void visit(@Nonnull EffectiveRepositoryPermission repositoryPermission) {
            this.values.add(ENCODING.encode(repositoryPermission.getPermission(), repositoryPermission.getRepositoryId()));
            return null;
        }

        private Pair<Long, List<Long>> partitionPermsByScope(List<Long> values) {
            Collections.sort(values);
            int resourcePermIndex = Math.max(0, Iterables.indexOf(values, IS_RESOURCE_PERM));
            long result = 0x100000000000000L;
            for (Long permission : values.subList(0, resourcePermIndex)) {
                result |= permission.longValue();
            }
            ArrayList resourcePerms = Lists.newArrayList(values.subList(resourcePermIndex, values.size()));
            return Pair.pair((Object)result, (Object)resourcePerms);
        }

        private boolean impliesProjectAdmin(long globalPermissions) {
            long projAdminPermission = Encoding.encodePermissionInt(Permission.PROJECT_ADMIN);
            return (globalPermissions & projAdminPermission) == projAdminPermission;
        }

        private boolean isNonEmpty(long globalPermission) {
            return globalPermission != 0x100000000000000L;
        }

        private List<Long> reduceResourcePerms(long globalPermission, List<Long> resourcePerms) {
            boolean hasGlobalPermission = this.isNonEmpty(globalPermission);
            ListIterator<Long> it = resourcePerms.listIterator();
            long prev = 0L;
            while (it.hasNext()) {
                long value = it.next();
                if (hasGlobalPermission && (globalPermission & Encoding.unmaskPermissionBits(value)) != 0L) {
                    it.remove();
                    continue;
                }
                if (Encoding.isSameCategoryAndResourceId(value, prev)) {
                    it.remove();
                    it.previous();
                    it.set(value |= prev);
                    it.next();
                }
                prev = value;
            }
            return resourcePerms;
        }
    }
}

