/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.ServerException;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.locale.DefaultLocaleService;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.atlassian.stash.internal.user.InternalAuthenticationContext;
import com.atlassian.stash.internal.user.InternalLocaleManager;
import com.atlassian.stash.internal.user.InternalNormalUser;
import com.atlassian.stash.internal.user.StashUserDao;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="localeManager")
public class DefaultLocaleManager
implements InternalLocaleManager {
    private final InternalAuthenticationContext authenticationContext;
    private final StashUserDao userDao;

    @Autowired
    public DefaultLocaleManager(StashUserDao userDao, InternalAuthenticationContext authenticationContext) {
        this.userDao = userDao;
        this.authenticationContext = authenticationContext;
    }

    @Transactional
    public void setLocale(@Nonnull ApplicationUser user, @Nullable Locale locale) throws ServerException {
        InternalNormalUser normalUser = DefaultLocaleService.getNormalUser((ApplicationUser)user);
        if (normalUser != null) {
            InternalApplicationUser updatedUser = (InternalApplicationUser)this.userDao.update((Object)new InternalNormalUser.Builder(normalUser).locale(locale).build());
            ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
            if (currentUser != null && user.getId() == currentUser.getId()) {
                SecurityContextHolder.getContext().setAuthentication((Authentication)this.authenticationContext.getCurrentToken().copyWithUser((ApplicationUser)updatedUser));
            }
        }
    }

    @Nullable
    public Locale getLocale(@Nullable ApplicationUser stashUser) {
        InternalNormalUser user = DefaultLocaleService.getNormalUser((ApplicationUser)stashUser);
        return user != null ? user.getLocale() : null;
    }
}

