/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.request;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.event.cluster.ClusterMembershipEvent;
import com.atlassian.bitbucket.event.request.RequestEndedEvent;
import com.atlassian.bitbucket.event.request.RequestStartedEvent;
import com.atlassian.bitbucket.request.RequestCallback;
import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.bitbucket.request.RequestInfoProvider;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.request.RequestMetadata;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.concurrent.StatefulService;
import com.atlassian.stash.internal.concurrent.TransferableState;
import com.atlassian.stash.internal.logback.LoggingConstants;
import com.atlassian.stash.internal.request.DefaultRequestContext;
import com.atlassian.stash.internal.request.DefaultRequestMetadata;
import java.time.Duration;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.CRC32;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.digest.DigestUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=RequestManager.class)
@Component(value="requestManager")
public class DefaultRequestManager
implements RequestManager,
StatefulService {
    private static final Logger accessLog = LoggerFactory.getLogger((String)LoggingConstants.LOGGER_ACCESS);
    private static final Logger log = LoggerFactory.getLogger(DefaultRequestManager.class);
    private final AuthenticationContext authenticationContext;
    private final AtomicLong concurrentCounter;
    private final AtomicLong requestCounter;
    private final EventPublisher eventPublisher;
    private final ThreadLocal<DefaultRequestContext> currentRequestContext;
    private final ThreadLocal<RequestMetadata> requestMetadata;
    private volatile boolean clustered;
    private ClusterService clusterService;
    private String nodeId;

    @Autowired
    public DefaultRequestManager(AuthenticationContext authenticationContext, EventPublisher eventPublisher) {
        this.authenticationContext = authenticationContext;
        this.eventPublisher = eventPublisher;
        this.concurrentCounter = new AtomicLong(0L);
        this.requestCounter = new AtomicLong(0L);
        this.currentRequestContext = new ThreadLocal();
        this.requestMetadata = new ThreadLocal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T, E extends Exception> T doAsRequest(@Nonnull RequestCallback<T, E> callback, @Nonnull RequestInfoProvider requestInfoProvider) throws E {
        if (this.currentRequestContext.get() == null) {
            long startTime = System.nanoTime();
            DefaultRequestContext requestContext = new DefaultRequestContext(this.authenticationContext, requestInfoProvider, this.generateRequestId());
            this.concurrentCounter.incrementAndGet();
            this.currentRequestContext.set(requestContext);
            this.logStartRequest(requestContext);
            this.eventPublisher.publish((Object)new RequestStartedEvent((Object)this, (RequestContext)requestContext));
            if (TimerUtils.isActive()) {
                Object object;
                String action = requestContext.getAction();
                try (Timer ignored = TimerUtils.start((String)action);){
                    object = callback.withRequest((RequestContext)requestContext);
                }
                return (T)object;
            }
            Object object = callback.withRequest((RequestContext)requestContext);
            return (T)object;
            finally {
                this.concurrentCounter.decrementAndGet();
                this.currentRequestContext.remove();
                try {
                    this.eventPublisher.publish((Object)new RequestEndedEvent((Object)this, (RequestContext)requestContext));
                }
                finally {
                    try {
                        this.logEndRequest(requestContext, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
                    }
                    finally {
                        MDC.clear();
                    }
                    requestContext.runCleanupCallbacks();
                }
            }
        }
        return (T)callback.withRequest((RequestContext)this.currentRequestContext.get());
    }

    @Nullable
    public RequestContext getRequestContext() {
        return (RequestContext)this.currentRequestContext.get();
    }

    @Nullable
    public RequestMetadata getRequestMetadata() {
        RequestMetadata md = this.requestMetadata.get();
        if (md == null) {
            return this.getRequestContext();
        }
        return md;
    }

    @EventListener
    public void onClusterMembershipChanged(ClusterMembershipEvent event) {
        this.clustered = event.getCurrentNodes().size() > 1;
    }

    @Autowired
    public void setClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
        this.nodeId = this.calcLocalNodeId();
        this.clustered = clusterService.isClustered();
    }

    protected String generateRequestId() {
        long count = this.requestCounter.incrementAndGet();
        return (this.clustered ? "*" : "@") + this.nodeId + "x" + new DateTime().getMinuteOfDay() + "x" + count + "x" + this.concurrentCounter.get();
    }

    private String calcLocalNodeId() {
        CRC32 crc = new CRC32();
        crc.update(DigestUtils.sha1((String)this.clusterService.getInformation().getLocalNode().getId()));
        return Long.toString(crc.getValue(), 36).toUpperCase(Locale.US);
    }

    protected void setupMDC(DefaultRequestContext requestContext) {
        MDC.put((String)"a-request-id", (String)requestContext.getId());
        MDC.put((String)"a-remote-address", (String)requestContext.getRemoteAddress());
        MDC.put((String)"a-request-details", (String)requestContext.getDetails());
        MDC.put((String)"a-session-id", (String)requestContext.getSessionId());
        MDC.put((String)"a-protocol", (String)requestContext.getProtocol());
        MDC.put((String)"a-request-action", (String)requestContext.getAction());
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        if (user != null) {
            MDC.put((String)"a-username", (String)user.getName());
        }
    }

    protected void logStartRequest(DefaultRequestContext requestInfo) {
        this.checkStaleMDCUsername();
        this.setupMDC(requestInfo);
        MDC.put((String)"a-in-out", (String)"i");
        accessLog.info("");
    }

    protected void logEndRequest(DefaultRequestContext requestInfo, long requestTime) {
        this.setupMDC(requestInfo);
        MDC.put((String)"a-request-time", (String)Long.toString(requestTime));
        MDC.put((String)"a-in-out", (String)"o");
        accessLog.info("");
        requestInfo.setDuration(Duration.ofMillis(requestTime));
    }

    @Nonnull
    public TransferableState getState() {
        return new RequestMetadataState(this.getRequestMetadata());
    }

    private void checkStaleMDCUsername() {
        String username;
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        if (user == null && (username = MDC.get((String)"a-username")) != null) {
            log.debug("No current user for the current request but MDC contains a request username: {}", (Object)username);
            MDC.remove((String)"a-username");
        }
    }

    private final class RequestMetadataState
    implements TransferableState {
        private final RequestMetadata metadata;

        public RequestMetadataState(RequestMetadata md) {
            this.metadata = md != null ? new DefaultRequestMetadata(md) : null;
        }

        public void apply() {
            DefaultRequestManager.this.requestMetadata.set(this.metadata);
        }

        public void remove() {
            DefaultRequestManager.this.requestMetadata.remove();
        }
    }
}

