/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.rescope;

import com.atlassian.bitbucket.concurrent.BucketProcessor;
import com.atlassian.bitbucket.concurrent.BucketedExecutor;
import com.atlassian.bitbucket.concurrent.BucketedExecutorSettings;
import com.atlassian.bitbucket.concurrent.ConcurrencyPolicy;
import com.atlassian.bitbucket.concurrent.ConcurrencyService;
import com.atlassian.bitbucket.event.repository.RepositoryRefsChangedEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.RescopeRequestDao;
import com.atlassian.stash.internal.pull.rescope.InternalPullRequestRescopeService;
import com.atlassian.stash.internal.pull.rescope.PullRequestRescopeTask;
import com.atlassian.stash.internal.pull.rescope.RepositoryRescopeResult;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.spring.AbstractSmartLifecycle;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class PullRequestRescopeBucketProcessor
extends AbstractSmartLifecycle
implements BucketProcessor<PullRequestRescopeTask> {
    private static final Logger log = LoggerFactory.getLogger(PullRequestRescopeBucketProcessor.class);
    private static final Predicate<RefChange> CHANGE_FILTER = refChange -> !StandardRefType.TAG.equals((Object)refChange.getRef().getType()) && !RefChangeType.ADD.equals((Object)refChange.getType());
    private final RescopeRequestDao dao;
    private final long delayIncrementSeconds;
    private final BucketedExecutor<PullRequestRescopeTask> executor;
    private final int maxAttempts;
    private final RepositoryService repositoryService;
    private final InternalPullRequestRescopeService rescopeService;
    private final TransactionTemplate transactionTemplate;
    private final EscalatedSecurityContext withRepoRead;

    @Autowired
    public PullRequestRescopeBucketProcessor(ConcurrencyService concurrencyService, RescopeRequestDao dao, RepositoryService repositoryService, InternalPullRequestRescopeService rescopeService, SecurityService securityService, PlatformTransactionManager transactionManager, @Value(value="${pullrequest.rescope.max.attempts}") int maxAttempts, @Value(value="${pullrequest.rescope.retry.delay.increment}") long delayIncrement, @Value(value="${pullrequest.rescope.threads}") int maxThreads) {
        this.dao = dao;
        this.delayIncrementSeconds = delayIncrement;
        this.maxAttempts = maxAttempts;
        this.repositoryService = repositoryService;
        this.rescopeService = rescopeService;
        this.executor = concurrencyService.getBucketedExecutor("pull-request-rescoping", new BucketedExecutorSettings.Builder(PullRequestRescopeTask.TO_BUCKET_ID, (BucketProcessor)this).maxAttempts(1).maxConcurrency(maxThreads, ConcurrencyPolicy.PER_NODE).build());
        this.transactionTemplate = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
        this.withRepoRead = securityService.withPermission(Permission.REPO_READ, ((Object)((Object)this)).getClass().getSimpleName());
    }

    public int getPhase() {
        return 1600;
    }

    @EventListener
    public void onRefsChanged(RepositoryRefsChangedEvent event) {
        Collection changes = (Collection)event.getRefChanges().stream().filter(CHANGE_FILTER).collect(MoreCollectors.toImmutableList());
        if (changes.isEmpty()) {
            return;
        }
        InternalRepository repository = InternalConverter.convertToInternalRepository((Repository)event.getRepository());
        InternalApplicationUser user = InternalConverter.convertToInternalUser((ApplicationUser)event.getUser());
        if (user == null) {
            log.warn("{}: Skipping rescopes because the triggering user could not be determined", (Object)repository);
            return;
        }
        this.rescopeService.createRequest(repository, user, changes);
        log.debug("{}: Scheduling rescope processing", (Object)repository);
        this.schedule(repository);
    }

    public void process(@Nonnull String bucketId, @Nonnull List<PullRequestRescopeTask> tasks) {
        if (tasks.isEmpty()) {
            return;
        }
        int repositoryId = tasks.get(0).getRepositoryId();
        InternalRepository repository = InternalConverter.convertToInternalRepository((Repository)((Repository)this.withRepoRead.call(() -> this.repositoryService.getById(repositoryId))));
        if (repository == null) {
            log.debug("-/-[{}]: Rescope processing skipped due to repository deletion", (Object)repositoryId);
            return;
        }
        RepositoryRescopeResult result = this.rescopeService.rescope((Repository)repository);
        this.transactionTemplate.execute(status -> {
            if (!result.isDone()) {
                int attempt = tasks.stream().mapToInt(PullRequestRescopeTask::getAttempt).max().orElse(1) + 1;
                if (attempt <= this.maxAttempts || result.hasSkippedAny()) {
                    long delayMs = attempt <= this.maxAttempts ? this.getDelayMillis(attempt) : InternalPullRequest.LOCK_TIMEOUT_MILLIS;
                    log.info("{}: Some pull requests were not rescoped. ({} failed, {} locked). Scheduling attempt {} in {}ms", new Object[]{repository, result.getErrorCount(), result.getSkippedCount(), attempt, delayMs});
                    this.schedule(repository, attempt, delayMs);
                } else {
                    log.warn("{}: Failed to rescope one or more pull requests ({} attempts)", (Object)repository, (Object)attempt);
                }
            }
            return null;
        });
    }

    public void start() {
        List repositoryIds = (List)this.transactionTemplate.execute(status -> this.dao.findPendingRepositoryIds());
        Iterator iterator = repositoryIds.iterator();
        while (iterator.hasNext()) {
            int repositoryId = (Integer)iterator.next();
            this.executor.submit((Serializable)new PullRequestRescopeTask(repositoryId, 1));
        }
        log.info("Rescheduled rescope processing for {} repositories: {}", (Object)repositoryIds.size(), (Object)repositoryIds);
        super.start();
    }

    public void stop() {
        this.executor.shutdown();
        super.stop();
    }

    private long getDelayMillis(int attempt) {
        return TimeUnit.SECONDS.toMillis(Math.max(0L, (long)(attempt - 1) * this.delayIncrementSeconds));
    }

    private void schedule(InternalRepository repository) {
        this.schedule(repository, 1, 0L);
    }

    private void schedule(InternalRepository repository, int attempt, long delayMs) {
        this.executor.schedule((Serializable)new PullRequestRescopeTask(repository.getId(), attempt), delayMs, TimeUnit.MILLISECONDS);
    }
}

