/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.rescope;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.pull.PullRequestSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.pull.RescopeDetails;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.ResolveRefsCommandParameters;
import com.atlassian.bitbucket.scm.pull.BulkRescopeCommandParameters;
import com.atlassian.bitbucket.scm.pull.BulkRescopeContext;
import com.atlassian.bitbucket.scm.pull.PullRequestRescope;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.PagedIterable;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestService;
import com.atlassian.stash.internal.pull.InternalRescopeRequest;
import com.atlassian.stash.internal.pull.RescopeRequestDao;
import com.atlassian.stash.internal.pull.rescope.DeclineOutcome;
import com.atlassian.stash.internal.pull.rescope.LegacyPullRequestRescopeService;
import com.atlassian.stash.internal.pull.rescope.MergeOutcome;
import com.atlassian.stash.internal.pull.rescope.PullRequestRescopeChain;
import com.atlassian.stash.internal.pull.rescope.RepositoryRescopeResult;
import com.atlassian.stash.internal.pull.rescope.RescopeOutcome;
import com.atlassian.stash.internal.pull.rescope.SimpleMinimalPullRequest;
import com.atlassian.stash.internal.pull.rescope.SimplePullRequestRescope;
import com.atlassian.stash.internal.pull.rescope.UpdateOutcome;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class DefaultPullRequestRescopeService
extends LegacyPullRequestRescopeService {
    private static final Logger log = LoggerFactory.getLogger(DefaultPullRequestRescopeService.class);
    private final AuthenticationContext authenticationContext;
    private final RescopeRequestDao dao;
    private final InternalScmService scmService;
    private final Map<String, Boolean> scmSupportsBulkRescopes;
    private final SecurityService securityService;
    private final InternalPullRequestService pullRequestService;
    @Value(value="${pullrequest.rescope.strategy.bulk}")
    private boolean bulkRescope;
    @Value(value="${pullrequest.rescope.commits.display}")
    private int maxCommitIds;

    public DefaultPullRequestRescopeService(AuthenticationContext authenticationContext, RescopeRequestDao dao, InternalPullRequestService pullRequestService, InternalScmService scmService, SecurityService securityService) {
        super(authenticationContext, dao, pullRequestService, scmService, securityService);
        this.authenticationContext = authenticationContext;
        this.dao = dao;
        this.pullRequestService = pullRequestService;
        this.scmService = scmService;
        this.securityService = securityService;
        this.scmSupportsBulkRescopes = new HashMap<String, Boolean>();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void createRequest(@Nonnull InternalRepository repository, @Nonnull InternalApplicationUser user, @Nonnull Collection<RefChange> changes) {
        this.dao.create((Object)new InternalRescopeRequest.Builder(repository, user).changes(changes).build());
    }

    @Override
    @Nonnull
    @PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
    @Transactional
    public RepositoryRescopeResult rescope(@Nonnull Repository repository, @Nonnull List<String> branchIds) {
        InternalApplicationUser user = InternalConverter.convertToInternalUser((ApplicationUser)this.authenticationContext.getCurrentUser());
        InternalRepository repo = InternalConverter.convertToInternalRepository((Repository)repository);
        List changes = branchIds.stream().map(LegacyPullRequestRescopeService.MarkerRefChange::new).collect(Collectors.toList());
        this.dao.create((Object)new InternalRescopeRequest.Builder(repo, user).changes(changes).build());
        return this.rescope(repository);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nonnull
    @Transactional
    public RepositoryRescopeResult rescope(@Nonnull Repository repository) {
        if (!this.isBulkRescopeSupported(repository)) return super.rescope(repository);
        try (Timer ignored = TimerUtils.start((String)(repository.toString() + ": bulk rescoping pull requests "));){
            RepositoryRescopeResult repositoryRescopeResult = (RepositoryRescopeResult)this.securityService.withPermission(Permission.REPO_READ, "Rescoping pull requests").call(() -> this.rescopeInternal(repository));
            return repositoryRescopeResult;
        }
        catch (UnsupportedOperationException e) {
            this.setBulkRescopeSupported(repository, false);
        }
        return super.rescope(repository);
    }

    @VisibleForTesting
    void setBulkRescope(boolean value) {
        this.bulkRescope = value;
    }

    @VisibleForTesting
    void setMaxCommitIds(int value) {
        this.maxCommitIds = value;
    }

    private int applyRescopes(RescopeContext rescopeContext, List<PullRequestRescopeChain> chains) {
        int errorCount = 0;
        block2: for (PullRequestRescopeChain chain : chains) {
            if (chain.getRescopes().isEmpty()) continue;
            int version = chain.getPullRequest().getVersion();
            long globalId = chain.getPullRequest().getGlobalId();
            for (int attempt = 1; attempt <= 3; ++attempt) {
                try {
                    this.pullRequestService.rescope(globalId, version, chain.getRescopes());
                    continue block2;
                }
                catch (RuntimeException e) {
                    if (attempt < 3) {
                        log.debug("Problem rescoping {} ({}/{})", new Object[]{chain.getPullRequest(), attempt, 3, e});
                        continue;
                    }
                    ++errorCount;
                    rescopeContext.markFailed(chain);
                    log.warn("Problem while rescoping {}", (Object)chain.getPullRequest(), (Object)e);
                    continue;
                }
            }
        }
        return errorCount;
    }

    private void deleteHandledRescopeRequests(RescopeContext context, List<InternalRescopeRequest> requests) {
        Date expiry = Date.from(ZonedDateTime.now().minusDays(1L).toInstant());
        requests.stream().filter(request -> context.isSafeToDelete((InternalRescopeRequest)request) || request.getCreatedDate().before(expiry)).forEach(arg_0 -> ((RescopeRequestDao)this.dao).delete(arg_0));
    }

    private void determineRescopes(Repository repository, List<PullRequestRescopeChain> chains) {
        this.scmService.bulkRescope(new BulkRescopeCommandParameters.Builder().repository(repository).rescopeContext((BulkRescopeContext)new SimpleBulkRescopeContext(chains, this.maxCommitIds)).build());
    }

    private Set<String> extractChangedRefs(List<InternalRescopeRequest> requests) {
        HashSet<String> refs = new HashSet<String>();
        for (InternalRescopeRequest request : requests) {
            if (request.getChanges().isEmpty()) {
                return Collections.emptySet();
            }
            request.getChanges().stream().map(change -> change.getRef().getId()).forEach(refs::add);
        }
        return refs;
    }

    private Iterable<PullRequest> findAffectedPullRequests(Repository repository, Set<String> branchIds) {
        if (branchIds.contains(null) || branchIds.isEmpty()) {
            return this.getOpenPullRequests(repository, Collections.emptyList());
        }
        Iterable<Object> result = Collections.emptyList();
        for (List partition : Iterables.partition(branchIds, (int)100)) {
            Iterable<PullRequest> pullRequests = this.getOpenPullRequests(repository, partition);
            result = Iterables.concat(result, pullRequests);
        }
        return result;
    }

    private Iterable<PullRequest> getOpenPullRequests(Repository repository, List<String> refIds) {
        PageRequest initialPageRequest = PageUtils.newRequest((int)0, (int)100);
        return Iterables.concat((Iterable)new PagedIterable(pageRequest -> this.pullRequestService.search(new PullRequestSearchRequest.Builder().toRepositoryId(Integer.valueOf(repository.getId())).toRefIds((Iterable)refIds).state(PullRequestState.OPEN).withProperties(false).build(), pageRequest), initialPageRequest), (Iterable)new PagedIterable(pageRequest -> this.pullRequestService.search(new PullRequestSearchRequest.Builder().fromRepositoryId(Integer.valueOf(repository.getId())).fromRefIds((Iterable)refIds).state(PullRequestState.OPEN).withProperties(false).build(), pageRequest), initialPageRequest));
    }

    private boolean isBulkRescopeSupported(Repository repository) {
        return this.scmSupportsBulkRescopes.computeIfAbsent(repository.getScmId(), scmId -> this.bulkRescope);
    }

    private RepositoryRescopeResult rescopeInternal(Repository repository) {
        List<PullRequestRescopeChain> chains;
        List rescopeRequests = this.dao.findByRepositories(Collections.singletonList(repository.getId()));
        if (rescopeRequests.isEmpty()) {
            return new RepositoryRescopeResult(0, 0);
        }
        RescopeContext rescopeContext = new RescopeContext(repository);
        List<PullRequestRescopeChain.Builder> chainBuilders = rescopeContext.createChainBuilders(this.findAffectedPullRequests(repository, this.extractChangedRefs(rescopeRequests)));
        if (chainBuilders.isEmpty()) {
            this.deleteHandledRescopeRequests(rescopeContext, rescopeRequests);
            return new RepositoryRescopeResult(rescopeContext.getLockedCount(), 0);
        }
        this.setTargetStateOnRescopeChains(rescopeContext, chainBuilders);
        List repositoryIds = rescopeContext.getAlternates().stream().map(Repository::getId).distinct().collect(Collectors.toList());
        repositoryIds.add(repository.getId());
        rescopeRequests = this.dao.findByRepositories(repositoryIds);
        try (Timer ignored = TimerUtils.start((String)"building rescope chains");){
            for (InternalRescopeRequest rescopeRequest : rescopeRequests) {
                for (PullRequestRescopeChain.Builder chainBuilder : chainBuilders) {
                    chainBuilder.request(rescopeRequest);
                }
            }
            chains = chainBuilders.stream().map(PullRequestRescopeChain.Builder::build).collect(Collectors.toList());
            chainBuilders = null;
        }
        this.determineRescopes(repository, chains);
        int errorCount = this.applyRescopes(rescopeContext, chains);
        this.deleteHandledRescopeRequests(rescopeContext, rescopeRequests);
        return new RepositoryRescopeResult(rescopeContext.getLockedCount(), errorCount);
    }

    private void resolveRefs(RescopeContext context) {
        this.resolveRefs(context.getRepository(), context);
        for (Repository alternate : context.getAlternates()) {
            this.resolveRefs(alternate, context);
        }
    }

    private void resolveRefs(Repository repository, RescopeContext context) {
        Map<String, String> repoRefs = context.getResolvedRefs(repository);
        Set refsToResolve = repoRefs.entrySet().stream().filter(entry -> entry.getValue() == null).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (refsToResolve.isEmpty()) {
            return;
        }
        Map resolved = (Map)this.scmService.getCommandFactory(repository).resolveRefs(new ResolveRefsCommandParameters.Builder().branchIds(refsToResolve).build()).call();
        resolved.forEach((refId, ref) -> repoRefs.put((String)refId, ref.getLatestCommit()));
    }

    private void setBulkRescopeSupported(Repository repository, boolean supported) {
        this.scmSupportsBulkRescopes.put(repository.getScmId(), supported);
    }

    private void setTargetStateOnRescopeChains(RescopeContext context, List<PullRequestRescopeChain.Builder> chainBuilders) {
        Date now = new Date();
        this.resolveRefs(context);
        for (PullRequestRescopeChain.Builder chain : chainBuilders) {
            SimpleMinimalPullRequest pullRequest = chain.getPullRequest();
            chain.targetState(now, context.resolve(pullRequest.getFromRef()), context.resolve(pullRequest.getToRef()));
        }
    }

    private static class SimpleBulkRescopeContext
    implements BulkRescopeContext {
        private final List<PullRequestRescopeChain> chains;
        private final int maxCommitIds;

        private SimpleBulkRescopeContext(List<PullRequestRescopeChain> chains, int maxCommitIds) {
            this.chains = chains;
            this.maxCommitIds = maxCommitIds;
        }

        public void decline(@Nonnull PullRequestRescope rescope) {
            this.asSimpleRescope(rescope).setOutcome((RescopeOutcome)new DeclineOutcome());
        }

        public int getMaxCommitIds() {
            return this.maxCommitIds;
        }

        public Iterator<PullRequestRescope> iterator() {
            return ((List)this.chains.stream().flatMap(chain -> chain.getRescopes().stream()).filter(rescope -> rescope.getOutcome() == null).collect(MoreCollectors.toImmutableList())).iterator();
        }

        public void merge(@Nonnull PullRequestRescope rescope, @Nullable String mergeHash) {
            this.asSimpleRescope(rescope).setOutcome((RescopeOutcome)new MergeOutcome(mergeHash));
        }

        public void update(@Nonnull PullRequestRescope rescope, @Nonnull RescopeDetails addedCommits, @Nonnull RescopeDetails removedCommits) {
            this.asSimpleRescope(rescope).setOutcome((RescopeOutcome)new UpdateOutcome(addedCommits, removedCommits));
        }

        private SimplePullRequestRescope asSimpleRescope(PullRequestRescope rescope) {
            if (rescope instanceof SimplePullRequestRescope) {
                return (SimplePullRequestRescope)SimplePullRequestRescope.class.cast(rescope);
            }
            throw new IllegalArgumentException("Only rescopes from the context can be used");
        }
    }

    private static class RescopeContext {
        private final Set<Repository> alternates;
        private final Map<Integer, Map<String, Date>> incompleteDateByRepoRef;
        private final Map<Repository, Map<String, String>> resolvedRefs;
        private final Repository repository;
        private int lockedCount;

        public RescopeContext(Repository repository) {
            this.repository = repository;
            this.alternates = new HashSet<Repository>();
            this.incompleteDateByRepoRef = new HashMap<Integer, Map<String, Date>>();
            this.resolvedRefs = new HashMap<Repository, Map<String, String>>();
        }

        public List<PullRequestRescopeChain.Builder> createChainBuilders(Iterable<PullRequest> pullRequests) {
            ArrayList<PullRequestRescopeChain.Builder> builders = new ArrayList<PullRequestRescopeChain.Builder>();
            HashSet<Long> globalIds = new HashSet<Long>();
            for (PullRequest pr : pullRequests) {
                InternalPullRequest pullRequest = InternalConverter.convertToInternalPullRequest((PullRequest)pr);
                if (!globalIds.add(pullRequest.getGlobalId())) continue;
                if (pullRequest.isLocked()) {
                    ++this.lockedCount;
                    this.markIncomplete((PullRequestRef)pullRequest.getFromRef(), pullRequest.getRescopedDate());
                    this.markIncomplete((PullRequestRef)pullRequest.getToRef(), pullRequest.getRescopedDate());
                    continue;
                }
                this.add((PullRequestRef)pullRequest.getFromRef());
                this.add((PullRequestRef)pullRequest.getToRef());
                builders.add(new PullRequestRescopeChain.Builder(pullRequest));
            }
            return builders;
        }

        public Set<Repository> getAlternates() {
            return this.alternates;
        }

        public int getLockedCount() {
            return this.lockedCount;
        }

        public Repository getRepository() {
            return this.repository;
        }

        public Map<String, String> getResolvedRefs(Repository repository) {
            return this.resolvedRefs.computeIfAbsent(repository, repo -> new HashMap());
        }

        public boolean isSafeToDelete(InternalRescopeRequest request) {
            if (!request.getRepository().equals((Object)this.repository)) {
                return false;
            }
            Map<String, Date> incompleteByRefId = this.incompleteDateByRepoRef.get(request.getRepository().getId());
            if (incompleteByRefId == null) {
                return true;
            }
            if (request.getChanges().isEmpty()) {
                return incompleteByRefId.values().stream().allMatch(incompleteAfter -> !request.getCreatedDate().after((Date)incompleteAfter));
            }
            for (RefChange change : request.getChanges()) {
                Date incompleteAfter2 = incompleteByRefId.get(change.getRef().getId());
                if (incompleteAfter2 == null || !request.getCreatedDate().after(incompleteAfter2)) continue;
                return false;
            }
            return true;
        }

        public void markFailed(PullRequestRescopeChain chain) {
            SimpleMinimalPullRequest pullRequest = chain.getPullRequest();
            this.markIncomplete(pullRequest.getFromRef(), pullRequest.getRescopeDate());
            this.markIncomplete(pullRequest.getToRef(), pullRequest.getRescopeDate());
        }

        public void markIncomplete(PullRequestRef ref, Date incompleteAfter) {
            Map incompleteByRefId = this.incompleteDateByRepoRef.computeIfAbsent(ref.getRepository().getId(), repoId -> new HashMap());
            incompleteByRefId.merge(ref.getId(), incompleteAfter, RescopeContext::oldest);
        }

        public String resolve(PullRequestRef ref) {
            return this.getResolvedRefs(ref.getRepository()).get(ref.getId());
        }

        private static Date oldest(Date date1, Date date2) {
            if (date1 == null) {
                return date2;
            }
            if (date2 == null) {
                return date1;
            }
            return date1.before(date2) ? date1 : date2;
        }

        private void add(PullRequestRef ref) {
            this.getResolvedRefs(ref.getRepository()).putIfAbsent(ref.getId(), null);
            if (!ref.getRepository().equals(this.repository)) {
                this.alternates.add(ref.getRepository());
            }
        }
    }
}

