/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.diff;

import com.atlassian.bitbucket.content.ConflictMarker;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.stash.internal.content.DiffLines;
import com.atlassian.stash.internal.pull.InternalPullRequestCommentActivity;
import com.atlassian.stash.internal.pull.comment.diff.DiffComment;
import com.atlassian.stash.internal.pull.comment.diff.DiffContext;
import com.atlassian.stash.internal.pull.comment.diff.DiffContextLine;
import com.atlassian.stash.internal.pull.comment.diff.DiffContextWindow;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffContextBatch {
    private static final Logger log = LoggerFactory.getLogger(DiffContextBatch.class);
    private final List<DiffContext> building;
    private final Set<DiffComment> foundComments;
    private final Set<DiffComment> searchComments;
    private final DiffContextWindow window;
    private DiffLines lines;
    private DiffSegmentType segmentType;

    public DiffContextBatch(Set<InternalPullRequestCommentActivity> activities, final PropertyMap properties) {
        Preconditions.checkArgument((!((Set)Preconditions.checkNotNull(activities, (Object)"activities")).isEmpty() ? 1 : 0) != 0, (Object)"At least one activity is required for the batch");
        this.searchComments = Sets.newHashSet((Iterable)Collections2.transform(activities, (Function)new Function<InternalPullRequestCommentActivity, DiffComment>(){

            public DiffComment apply(InternalPullRequestCommentActivity activity) {
                return new DiffComment(activity, properties);
            }
        }));
        log.debug("Searching for context for {} comment(s)", (Object)this.searchComments.size());
        this.building = Lists.newArrayListWithCapacity((int)activities.size());
        this.foundComments = Sets.newHashSetWithExpectedSize((int)activities.size());
        this.window = new DiffContextWindow();
    }

    public void endDiff() {
        if (!this.building.isEmpty()) {
            log.warn("endHunk() was not called for the final hunk before calling done(); {} comment(s) were still assembling their context", (Object)this.building.size());
            this.endHunk();
        }
        if (this.searchComments.isEmpty()) {
            log.debug("Context has been applied for all {} comment(s)", (Object)this.foundComments.size());
        } else {
            log.debug("Context has been applied for {} comment(s); {} comment(s) were not found", (Object)this.foundComments.size(), (Object)this.searchComments.size());
        }
    }

    public void endHunk() {
        for (DiffContext context : this.building) {
            context.done();
        }
        this.building.clear();
        this.window.clear();
    }

    public void processLine(String line, ConflictMarker marker, boolean truncated) {
        if (this.building.isEmpty() && this.searchComments.isEmpty()) {
            return;
        }
        DiffContextLine contextLine = this.lines.withLines(this.segmentType, line, marker, truncated, DiffContextLine.FACTORY_CALLBACK);
        Iterator<DiffContext> workingIterator = this.building.iterator();
        while (workingIterator.hasNext()) {
            DiffContext context = workingIterator.next();
            if (context.offer(contextLine)) continue;
            context.done();
            workingIterator.remove();
        }
        Iterator<DiffComment> searchIterator = this.searchComments.iterator();
        while (searchIterator.hasNext()) {
            DiffComment comment = searchIterator.next();
            if (!comment.isAnchoredOn(contextLine)) continue;
            this.building.add(new DiffContext(comment, contextLine, this.window.snapshot()));
            this.foundComments.add(comment);
            searchIterator.remove();
        }
        this.window.slide(contextLine);
    }

    public void startHunk(int srcLine, int dstLine) {
        this.lines = new DiffLines(srcLine, dstLine);
    }

    public void startSegment(DiffSegmentType segmentType) {
        this.segmentType = segmentType;
    }
}

