/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentChain;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.comment.InternalCommentOperations;
import com.atlassian.stash.internal.comment.InternalCommentable;
import com.atlassian.stash.internal.pull.comment.CommentPostProcessor;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class OperationCommentPostProcessor
implements CommentPostProcessor {
    private final AuthenticationContext authenticationContext;
    private final PermissionService permissionService;

    public OperationCommentPostProcessor(AuthenticationContext authenticationContext, PermissionService permissionService) {
        this.authenticationContext = authenticationContext;
        this.permissionService = permissionService;
    }

    @Override
    public InternalComment process(InternalCommentable entity, InternalComment rootComment) {
        this.processAll(entity, (Set<InternalComment>)ImmutableSet.of((Object)rootComment));
        return rootComment;
    }

    @Override
    public Set<InternalComment> processAll(InternalCommentable entity, Set<InternalComment> rootComments) {
        if (rootComments.isEmpty()) {
            return rootComments;
        }
        CommentChain allComments = new CommentChain(rootComments);
        InternalRepository repository = entity.getScopeRepository();
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        boolean isRepoAdmin = this.isRepoAdmin(repository);
        for (InternalComment comment : allComments) {
            this.process(comment, currentUser, isRepoAdmin);
        }
        return rootComments;
    }

    private void process(InternalComment comment, ApplicationUser currentUser, boolean isRepoAdmin) {
        if (comment.getPermittedOperations() == null) {
            comment.setPermittedOperations(InternalCommentOperations.of((boolean)OperationCommentPostProcessor.canEdit(currentUser, (Comment)comment), (boolean)OperationCommentPostProcessor.canDelete(currentUser, (Comment)comment, isRepoAdmin)));
        }
    }

    private boolean isRepoAdmin(InternalRepository repository) {
        return this.permissionService.hasRepositoryPermission((Repository)repository, Permission.REPO_ADMIN);
    }

    private static boolean canEdit(ApplicationUser currentUser, Comment comment) {
        return comment.getAuthor().equals(currentUser);
    }

    private static boolean canDelete(ApplicationUser currentUser, Comment comment, boolean isRepoAdmin) {
        return isRepoAdmin || comment.getAuthor().equals(currentUser);
    }
}

