/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification;

import com.atlassian.bitbucket.notification.Notification;
import com.atlassian.bitbucket.notification.pull.PullRequestNotification;
import com.atlassian.bitbucket.notification.pull.PullRequestReviewedNotification;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.stash.internal.notification.NotificationAddresser;
import com.atlassian.stash.internal.notification.NotificationManager;
import com.atlassian.stash.internal.plugin.NotificationHandlerModuleDescriptor;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultNotificationManager
implements NotificationManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultNotificationManager.class);
    private final PluginAccessor pluginAccessor;
    private final PluginController pluginController;
    private final NotificationAddresser notificationAddresser;

    @Autowired
    public DefaultNotificationManager(PluginAccessor pluginAccessor, PluginController pluginController, NotificationAddresser notificationAddresser) {
        this.pluginAccessor = pluginAccessor;
        this.pluginController = pluginController;
        this.notificationAddresser = notificationAddresser;
    }

    @Override
    public void dispatch(Notification notification) {
        Set recipients;
        log.debug("Managing notification: {}", (Object)notification);
        ApplicationUser initiator = notification.getUser();
        if (notification instanceof PullRequestReviewedNotification) {
            ApplicationUser author = ((PullRequestNotification)notification).getPullRequest().getAuthor().getUser();
            recipients = Collections.singleton(author);
        } else {
            recipients = (Set)MoreStreams.streamIterable(this.notificationAddresser.getRecipients(notification)).filter(user -> initiator == null || !user.equals(initiator)).collect(MoreCollectors.toImmutableSet());
        }
        this.dispatch(notification, recipients);
    }

    private void dispatch(Notification notification, Iterable<ApplicationUser> recipients) {
        Class<?> notificationClass = notification.getClass();
        this.pluginAccessor.getEnabledModuleDescriptorsByClass(NotificationHandlerModuleDescriptor.class).stream().filter(descriptor -> descriptor.getNotificationClass().equals(notificationClass.getCanonicalName())).forEach(descriptor -> {
            try {
                descriptor.getModule().handle(notification, recipients);
            }
            catch (ClassCastException e) {
                String completeModuleKey = descriptor.getCompleteKey();
                log.error("ClassCastException thrown by plugin module {} when handling notification with class {}. Disabling.", (Object)completeModuleKey, (Object)notificationClass);
                log.debug("ClassCastException", (Throwable)e);
                this.pluginController.disablePluginModule(completeModuleKey);
            }
        });
    }
}

