/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.i18n;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.LocaleUtils;

public class LocaleBuilder {
    private final List<Locale> locales = Lists.newArrayList();

    public LocaleBuilder add(Locale locale) {
        if (locale != null) {
            this.addSubLocales(locale);
        }
        return this;
    }

    public LocaleBuilder addAll(Iterable<Locale> locales) {
        for (Locale locale : locales) {
            this.add(locale);
        }
        return this;
    }

    public List<Locale> build() {
        return this.locales;
    }

    private void addSubLocales(Locale locale) {
        for (Locale subLocale : LocaleUtils.localeLookupList((Locale)locale)) {
            if (this.locales.contains(subLocale)) {
                return;
            }
            this.locales.add(subLocale);
        }
    }
}

