/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook.repository;

import com.atlassian.bitbucket.event.repository.RepositoryRefsChangedEvent;
import com.atlassian.bitbucket.hook.repository.AsyncPostReceiveRepositoryHook;
import com.atlassian.bitbucket.hook.repository.RepositoryHookContext;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.setting.Settings;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.hook.repository.InternalRepositoryHookService;
import com.atlassian.stash.internal.hook.repository.RepositoryHookSettingsCallback;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AsyncPostReceiveRepositoryHookAdapter {
    private static final Logger log = LoggerFactory.getLogger(AsyncPostReceiveRepositoryHookAdapter.class);
    private final InternalRepositoryHookService hookService;

    @Autowired
    public AsyncPostReceiveRepositoryHookAdapter(InternalRepositoryHookService hookService) {
        this.hookService = hookService;
    }

    @EventListener
    public void onRefsChangedEvent(RepositoryRefsChangedEvent event) {
        if (!event.getRefChanges().isEmpty()) {
            this.postReceive(event.getRepository(), event.getRefChanges());
        }
    }

    private void postReceive(final Repository repository, final Collection<RefChange> refChanges) {
        this.hookService.visitEnabledHooks(repository, AsyncPostReceiveRepositoryHook.class, (RepositoryHookSettingsCallback)new RepositoryHookSettingsCallback<AsyncPostReceiveRepositoryHook>(){

            public boolean visit(@Nonnull String key, @Nonnull AsyncPostReceiveRepositoryHook hook, @Nonnull Settings settings) {
                try (Timer timer = TimerUtils.start((String)(hook.getClass().getName() + "#postReceive"));){
                    hook.postReceive(new RepositoryHookContext(repository, settings), refChanges);
                }
                catch (Exception e) {
                    log.warn("Push Event Hook " + hook.getClass().getName() + " failed.", (Throwable)e);
                }
                return true;
            }
        });
    }
}

