/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.db;

import com.atlassian.stash.internal.db.DatabaseHandle;
import com.atlassian.stash.internal.jdbc.DataSourceConfiguration;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class DefaultDatabaseHandle
implements DatabaseHandle {
    private static final Logger log = LoggerFactory.getLogger(DefaultDatabaseHandle.class);
    private final DataSourceConfiguration configuration;
    private final DataSource dataSource;
    private final SessionFactoryImplementor sessionFactory;

    public DefaultDatabaseHandle(DataSourceConfiguration configuration, DataSource dataSource, SessionFactoryImplementor sessionFactory) {
        this.configuration = configuration;
        this.dataSource = dataSource;
        this.sessionFactory = sessionFactory;
    }

    public void close() {
        this.closeDataSource(this.dataSource);
    }

    @Nonnull
    public DataSourceConfiguration getConfiguration() {
        return this.configuration;
    }

    @Nonnull
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Nonnull
    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    private void closeDataSource(@Nonnull DataSource dataSource) {
        Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        log.debug("Closing DataSource to release database connections");
        if (dataSource instanceof Closeable) {
            try {
                ((Closeable)((Object)dataSource)).close();
            }
            catch (IOException e) {
                log.warn("DataSource raised an exception while being closed.", (Throwable)e);
            }
        } else {
            Class<?> dataSourceClass = dataSource.getClass();
            log.debug("DataSource class [{}] does not implement Closeable", dataSourceClass);
            Method close = ReflectionUtils.findMethod(dataSourceClass, (String)"close");
            if (close == null) {
                log.warn("DataSource class [{}] does not have a close() method and will not be closed.", dataSourceClass);
            } else {
                log.debug("Invoking {}.{}() to close the DataSource", close.getDeclaringClass(), (Object)close.getName());
                try {
                    ReflectionUtils.invokeMethod((Method)close, (Object)dataSource);
                }
                catch (Throwable t) {
                    log.warn(dataSourceClass + "." + close.getName() + "() did not run cleanly. " + "The DataSource may not have been closed", t);
                }
            }
        }
    }
}

