/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.stash.internal.crowd.RiotPolice;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nonnull;

abstract class Filter<T> {
    private final RiotPolice crowdControl;

    Filter(RiotPolice crowdControl) {
        this.crowdControl = crowdControl;
    }

    abstract Query<T> getQuery(String var1, int var2, int var3);

    abstract boolean isMatch(T var1);

    Page<T> scan(@Nonnull PageRequest pageRequest, @Nonnull String entity) {
        int fetchSize = pageRequest.getLimit() * 2;
        int limit = pageRequest.getLimit() + 1;
        int matched = 0;
        int offset = 0;
        int start = pageRequest.getStart();
        ArrayList matches = Lists.newArrayListWithCapacity((int)limit);
        do {
            Iterable<T> candidates = this.crowdControl.search(this.getQuery(entity, offset, fetchSize));
            for (T candidate : candidates) {
                if (!this.isMatch(candidate) || matched++ < start) continue;
                matches.add(candidate);
                if (matches.size() < limit) continue;
                break;
            }
            if (Iterables.size(candidates) < fetchSize) break;
            offset += fetchSize;
        } while (matches.size() < limit);
        return PageUtils.createPage((Iterable)matches, (PageRequest)pageRequest);
    }
}

