/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.content;

import com.atlassian.bitbucket.ServerException;
import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.content.Blame;
import com.atlassian.bitbucket.content.ContentService;
import com.atlassian.bitbucket.content.ContentTreeCallback;
import com.atlassian.bitbucket.content.ContentTreeNode;
import com.atlassian.bitbucket.content.FileContentCallback;
import com.atlassian.bitbucket.content.FileContext;
import com.atlassian.bitbucket.content.FileSummary;
import com.atlassian.bitbucket.content.NoSuchPathException;
import com.atlassian.bitbucket.content.SimpleBlame;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.io.TypeAwareOutputSupplier;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.BlameCommandParameters;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.CommandException;
import com.atlassian.bitbucket.scm.DirectoryCommandParameters;
import com.atlassian.bitbucket.scm.FileCommandParameters;
import com.atlassian.bitbucket.scm.RawFileCommandParameters;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.scm.TypeCommandParameters;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.scm.AbstractScmService;
import com.atlassian.stash.internal.user.InternalUserService;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=ContentService.class)
@PreAuthorize(value="isRepositoryAccessible(#repository)")
@Service(value="contentService")
public class DefaultContentService
extends AbstractScmService
implements ContentService {
    private static final Logger log = LoggerFactory.getLogger(DefaultContentService.class);
    private final I18nService i18nService;
    private final InternalUserService userService;

    @Autowired
    public DefaultContentService(ScmService scmService, I18nService i18nService, InternalUserService userService) {
        super(scmService);
        this.i18nService = i18nService;
        this.userService = userService;
    }

    @Nonnull
    public List<Blame> getBlame(@Nonnull Repository repository, @Nonnull String objectId, @Nonnull String path, @Nonnull PageRequest pageRequest) {
        List blame = (List)this.getCommandFactory(repository).blame(((BlameCommandParameters.Builder)((BlameCommandParameters.Builder)new BlameCommandParameters.Builder().commitId(objectId)).path(path)).build(), pageRequest).call();
        return blame == null ? Collections.emptyList() : this.updateAuthors(blame);
    }

    @Nonnull
    public ContentTreeNode.Type getType(@Nonnull Repository repository, @Nonnull String objectId, String path) {
        ContentTreeNode.Type type = (ContentTreeNode.Type)this.getCommandFactory(repository).type(((TypeCommandParameters.Builder)((TypeCommandParameters.Builder)new TypeCommandParameters.Builder().commitId(objectId)).path(path)).build()).call();
        if (type == null) {
            throw new NoSuchPathException(this.i18nService.createKeyedMessage("bitbucket.service.content.type.none", new Object[]{path, objectId}), path, objectId);
        }
        return type;
    }

    public void streamDirectory(@Nonnull Repository repository, @Nonnull String objectId, String path, boolean recursive, @Nonnull ContentTreeCallback callback, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(recursive ? this.maxDirectoryRecursiveChildren : this.maxDirectoryChildren);
        DirectoryCommandParameters parameters = ((DirectoryCommandParameters.Builder)((DirectoryCommandParameters.Builder)new DirectoryCommandParameters.Builder().commitId(objectId)).path(path)).recurse(recursive).withSizes(!recursive).build();
        this.getCommandFactory(repository).directory(parameters, callback, pageRequest).call();
    }

    public void streamFile(@Nonnull Repository repository, @Nonnull String objectId, @Nonnull String path, @Nonnull PageRequest pageRequest, boolean withBlame, @Nonnull FileContentCallback callback) throws ServiceException {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxSourceLines);
        if (withBlame) {
            callback = new AuthorUpdatingFileContentCallback(callback);
        }
        FileCommandParameters parameters = ((FileCommandParameters.Builder)((FileCommandParameters.Builder)new FileCommandParameters.Builder().annotate(withBlame).commitId(objectId)).maxLineLength(this.maxLineLength).path(path)).build();
        Command command = this.getCommandFactory(repository).file(parameters, callback, pageRequest);
        try {
            command.call();
        }
        catch (CommandException e) {
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            log.error("{}: Error streaming {}:{}", new Object[]{repository, objectId, path, rootCause});
            throw this.unexpectedError(rootCause);
        }
    }

    public void streamFile(@Nonnull Repository repository, @Nonnull String objectId, @Nonnull String path, @Nonnull TypeAwareOutputSupplier supplier) throws ServiceException {
        RawFileCommandParameters parameters = ((RawFileCommandParameters.Builder)((RawFileCommandParameters.Builder)new RawFileCommandParameters.Builder().commitId(objectId)).path(path)).build();
        this.getCommandFactory(repository).rawFile(parameters, supplier).call();
    }

    private ServerException unexpectedError(Throwable cause) {
        throw new ServerException(this.i18nService.createKeyedMessage("bitbucket.service.unexpected", new Object[0]), cause);
    }

    private List<Blame> updateAuthors(List<? extends Blame> blames) {
        if (CollectionUtils.isEmpty(blames)) {
            return blames;
        }
        Set emailAddresses = Chainable.chain(blames).transform(Blame.TO_AUTHOR).transform(Person.TO_EMAIL_ADDRESS).filter(StringUtils::isNotBlank).toSet();
        Map usersByEmail = this.userService.mapUsersByEmail(emailAddresses);
        if (!usersByEmail.isEmpty()) {
            blames = Chainable.chain(blames).transform(blame -> {
                ApplicationUser user = (ApplicationUser)usersByEmail.get(blame.getAuthor().getEmailAddress());
                if (user != null) {
                    return new SimpleBlame.Builder(blame).author((Person)user).build();
                }
                return blame;
            }).toList();
        }
        return blames;
    }

    private class AuthorUpdatingFileContentCallback
    implements FileContentCallback {
        private final FileContentCallback delegate;

        public AuthorUpdatingFileContentCallback(FileContentCallback callback) {
            this.delegate = callback;
        }

        public void offerBlame(@Nonnull List<Blame> blames) throws IOException {
            this.delegate.offerBlame(DefaultContentService.this.updateAuthors(blames));
        }

        public void onBinary() throws IOException {
            this.delegate.onBinary();
        }

        public void onEnd(@Nonnull FileSummary summary) throws IOException {
            this.delegate.onEnd(summary);
        }

        public void onStart(@Nonnull FileContext context) throws IOException {
            this.delegate.onStart(context);
        }

        public boolean onLine(int lineNumber, String line, boolean truncated) throws IOException {
            return this.delegate.onLine(lineNumber, line, truncated);
        }
    }
}

