/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.bitbucket.concurrent.RepositoryLock;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.stash.internal.concurrent.ClusterMappedLock;
import com.google.common.base.Preconditions;
import com.hazelcast.core.HazelcastInstance;
import javax.annotation.Nonnull;

public class HazelcastRepositoryLock
implements RepositoryLock {
    private static final String LOCK_PREFIX = "lock.stash.repository.";
    private final ClusterMappedLock lock;

    public HazelcastRepositoryLock(HazelcastInstance hazelcastInstance, String lockName) {
        this.lock = new ClusterMappedLock(hazelcastInstance, LOCK_PREFIX + lockName);
    }

    public <T, E extends Exception> T withLock(int repositoryId, @Nonnull Operation<T, E> operation) throws E {
        return this.lock.withLock(Integer.toString(repositoryId), operation);
    }

    public <T, E extends Exception> T withLock(@Nonnull Repository repository, @Nonnull Operation<T, E> operation) throws E {
        return this.lock.withLock(Integer.toString(((Repository)Preconditions.checkNotNull((Object)repository, (Object)"repository")).getId()), operation);
    }
}

