/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.cluster;

import com.atlassian.stash.internal.cluster.ClusterJoinCheck;
import com.atlassian.stash.internal.cluster.ClusterJoinCheckAction;
import com.atlassian.stash.internal.cluster.ClusterJoinCheckResult;
import com.atlassian.stash.internal.cluster.ClusterJoinRequest;
import com.atlassian.stash.internal.cluster.ClusterJoinRequirement;
import com.google.common.collect.Maps;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RequirementsClusterJoinCheck
implements ClusterJoinCheck {
    private final Map<String, ClusterJoinRequirement> requirements;

    @Autowired
    public RequirementsClusterJoinCheck(ClusterJoinRequirement ... requirements) {
        this.requirements = new HashMap<String, ClusterJoinRequirement>(requirements.length);
        for (ClusterJoinRequirement requirement : requirements) {
            this.requirements.put(requirement.getName(), requirement);
        }
    }

    @Override
    @Nonnull
    public ClusterJoinCheckResult accept(@Nonnull ClusterJoinRequest request) throws IOException {
        ClusterJoinCheckResult.Builder resultBuilder = new ClusterJoinCheckResult.Builder();
        HashMap requirements = Maps.newHashMap(this.requirements);
        try {
            Map<String, String> remoteRequirements = RequirementsClusterJoinCheck.readMap(request.in());
            for (Map.Entry<String, String> entry : remoteRequirements.entrySet()) {
                String name = entry.getKey();
                String expected = entry.getValue();
                ClusterJoinRequirement requirement = (ClusterJoinRequirement)requirements.remove(name);
                if (requirement == null) {
                    resultBuilder.passivate(ClusterJoinCheckAction.PASSIVATE_ANY_NODE, "Connecting node requires property '" + name + "' to be '" + expected + "' but the property is not defined");
                    continue;
                }
                String actual = requirement.getValue();
                if (Objects.equals(expected, actual)) continue;
                resultBuilder.passivate(ClusterJoinCheckAction.PASSIVATE_ANY_NODE, "Required property '" + name + "' should be '" + expected + "' but is '" + actual + "'");
            }
            for (String missing : requirements.keySet()) {
                resultBuilder.passivate(ClusterJoinCheckAction.PASSIVATE_ANY_NODE, "Connecting node did not provide required property '" + missing + "'");
            }
        }
        catch (NoClassDefFoundError e) {
            resultBuilder.passivate(ClusterJoinCheckAction.PASSIVATE_ANY_NODE, "Could not validate whether the node meets the requirements for connecting to the cluster: '" + e.getMessage() + "'");
        }
        return resultBuilder.build();
    }

    @Override
    @Nonnull
    public ClusterJoinCheckResult connect(@Nonnull ClusterJoinRequest request) throws IOException {
        HashMap<String, String> expectedValues = new HashMap<String, String>(this.requirements.size());
        for (ClusterJoinRequirement requirement : this.requirements.values()) {
            expectedValues.put(requirement.getName(), requirement.getValue());
        }
        RequirementsClusterJoinCheck.writeMap(request.out(), expectedValues);
        return ClusterJoinCheckResult.OK;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.getClass().getName();
    }

    public int getOrder() {
        return 10;
    }

    @Override
    @Nonnull
    public ClusterJoinCheckResult onUnknown(@Nonnull ClusterJoinRequest request) {
        ClusterJoinCheckResult.Builder resultBuilder = new ClusterJoinCheckResult.Builder();
        for (String missing : this.requirements.keySet()) {
            resultBuilder.passivate(ClusterJoinCheckAction.PASSIVATE_ANY_NODE, "Node did not provide required property '" + missing + "'");
        }
        return resultBuilder.build();
    }

    private static Map<String, String> readMap(ObjectDataInput in) throws IOException {
        int length = in.readInt();
        HashMap<String, String> map = new HashMap<String, String>(length, 1.0f);
        for (int i = 0; i < length; ++i) {
            map.put(in.readUTF(), in.readUTF());
        }
        return map;
    }

    private static void writeMap(ObjectDataOutput out, Map<String, String> map) throws IOException {
        out.writeInt(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeUTF(entry.getValue());
        }
    }
}

