/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.cluster;

import com.atlassian.stash.internal.cluster.ClusterJoinCheckAction;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;

public class ClusterJoinCheckResult {
    public static final ClusterJoinCheckResult OK = new Builder().build();
    private final ClusterJoinCheckAction action;
    private final ImmutableList<String> messages;

    private ClusterJoinCheckResult(ClusterJoinCheckAction action, ImmutableList<String> messages) {
        this.action = (ClusterJoinCheckAction)((Object)Preconditions.checkNotNull((Object)((Object)action), (Object)"action"));
        this.messages = (ImmutableList)Preconditions.checkNotNull(messages, (Object)"messages");
    }

    @Nonnull
    public static ClusterJoinCheckResult disconnect(@Nonnull String message) {
        return new Builder().disconnect(message).build();
    }

    @Nonnull
    public static ClusterJoinCheckResult passivate(@Nonnull ClusterJoinCheckAction action, @Nonnull String message) {
        return new Builder().passivate(action, message).build();
    }

    @Nonnull
    public ClusterJoinCheckAction getAction() {
        return this.action;
    }

    @Nonnull
    public ImmutableList<String> getMessages() {
        return this.messages;
    }

    public static class Builder {
        private final ImmutableList.Builder<String> messages = ImmutableList.builder();
        private ClusterJoinCheckAction action = ClusterJoinCheckAction.CONNECT;

        @Nonnull
        public ClusterJoinCheckResult build() {
            return new ClusterJoinCheckResult(this.action, this.messages.build());
        }

        @Nonnull
        public Builder action(@Nonnull ClusterJoinCheckAction action, @Nonnull String message) {
            this.messages.add(Preconditions.checkNotNull((Object)message, (Object)"message"));
            if (this.action.getId() < ((ClusterJoinCheckAction)((Object)Preconditions.checkNotNull((Object)((Object)action), (Object)"action"))).getId()) {
                this.action = action;
            }
            return this;
        }

        @Nonnull
        public Builder disconnect(@Nonnull String message) {
            return this.action(ClusterJoinCheckAction.DISCONNECT, message);
        }

        @Nonnull
        public Builder passivate(@Nonnull ClusterJoinCheckAction action, @Nonnull String message) {
            Preconditions.checkArgument((boolean)((ClusterJoinCheckAction)((Object)Preconditions.checkNotNull((Object)((Object)action), (Object)"action"))).isPassivate(), (Object)((Object)((Object)action) + " incompatible with passivate"));
            return this.action(action, message);
        }
    }
}

