/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth.trusted;

import com.atlassian.security.auth.trustedapps.BouncyCastleEncryptionProvider;
import java.util.Locale;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeEncryptionProvider
extends BouncyCastleEncryptionProvider {
    private static final Logger log = LoggerFactory.getLogger(SafeEncryptionProvider.class);

    public String generateUID() {
        try {
            return super.generateUID();
        }
        catch (Exception e) {
            log.warn("UID generation failed. Falling back on UUID", (Throwable)e);
            return this.generateUidFromUuid();
        }
    }

    String generateUidFromUuid() {
        return UUID.randomUUID().toString().replace("-", "").toUpperCase(Locale.US);
    }
}

