/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.rescope;

import com.atlassian.bitbucket.pull.RescopeDetails;
import com.atlassian.stash.internal.pull.rescope.RescopeOutcome;
import com.atlassian.stash.internal.pull.rescope.RescopeOutcomeVisitor;
import java.util.Objects;
import javax.annotation.Nonnull;

public class UpdateOutcome
implements RescopeOutcome {
    private final RescopeDetails addedCommits;
    private final RescopeDetails removedCommits;

    public UpdateOutcome(@Nonnull RescopeDetails addedCommits, @Nonnull RescopeDetails removedCommits) {
        this.addedCommits = Objects.requireNonNull(addedCommits, "addedCommits");
        this.removedCommits = Objects.requireNonNull(removedCommits, "removedCommits");
    }

    @Override
    public <T> T accept(@Nonnull RescopeOutcomeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateOutcome that = (UpdateOutcome)o;
        return Objects.equals(this.addedCommits, that.addedCommits) && Objects.equals(this.removedCommits, that.removedCommits);
    }

    @Nonnull
    public RescopeDetails getAddedCommits() {
        return this.addedCommits;
    }

    @Nonnull
    public RescopeDetails getRemovedCommits() {
        return this.removedCommits;
    }

    public int hashCode() {
        return Objects.hash(this.addedCommits, this.removedCommits);
    }

    public String toString() {
        return "{UpdateOutcome added: " + this.addedCommits + ", removed: " + this.removedCommits + "}";
    }
}

