/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.avatar;

import com.atlassian.bitbucket.avatar.AvatarSupplier;
import com.atlassian.stash.internal.avatar.ResourceAvatarSupplier;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.MediaType;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public enum AvatarType {
    PROJECT(1, "projects", MediaType.SVG_UTF_8){
        private final List<String> colours = ImmutableList.of((Object)"blue", (Object)"green", (Object)"purple", (Object)"red", (Object)"yellow");

        @Override
        @Nonnull
        protected String buildPath(@Nonnull String id, int size) {
            Preconditions.checkNotNull((Object)id, (Object)"id");
            Preconditions.checkArgument((boolean)DEFAULT_SIZES.contains(size), (Object)("Default project avatars are not available in " + size + "px"));
            int hash = id.hashCode();
            int selection = Math.abs(hash % this.colours.size());
            String colour = this.colours.get(selection);
            return "avatars/project/" + colour + "/" + size + ".svg";
        }
    }
    ,
    USER(2, "users", MediaType.PNG){

        @Override
        @Nonnull
        protected String buildPath(@Nonnull String id, int size) {
            Preconditions.checkNotNull((Object)id, (Object)"id");
            Preconditions.checkArgument((boolean)DEFAULT_SIZES.contains(size), (Object)("Default user avatars are not available in " + size + "px"));
            return "avatars/user/" + size + ".png";
        }
    };

    static final Set<Integer> DEFAULT_SIZES;
    private final String contentType;
    private final String directoryName;
    private final int id;

    private AvatarType(int id, String directoryName, MediaType mediaType) {
        this.directoryName = (String)Preconditions.checkNotNull((Object)directoryName, (Object)"directoryName");
        this.id = id;
        this.contentType = mediaType.toString();
    }

    public static AvatarType fromId(int id) {
        for (AvatarType value : AvatarType.values()) {
            if (value.getId() != id) continue;
            return value;
        }
        throw new IllegalArgumentException("No AvatarType is available for ID " + id);
    }

    @Nonnull
    public String getContentType() {
        return this.contentType;
    }

    @Nonnull
    public String getDirectoryName() {
        return this.directoryName;
    }

    public int getId() {
        return this.id;
    }

    @Nonnull
    public AvatarSupplier loadDefault(@Nonnull String id, int size) {
        return new ResourceAvatarSupplier(this.contentType, this.buildPath(id, size));
    }

    @Nonnull
    public AvatarSupplier loadFixedDefault(int size) {
        return this.loadDefault("unknown", size);
    }

    @Nonnull
    protected abstract String buildPath(@Nonnull String var1, int var2);

    static {
        DEFAULT_SIZES = ImmutableSet.of((Object)48, (Object)64, (Object)96, (Object)128, (Object)256);
    }
}

