/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.bitbucket.auth.HttpAuthenticationSuccessContext;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class HttpAuthUtils {
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String AUTH_PREFIX_BASIC = "Basic ";

    private HttpAuthUtils() {
    }

    public static boolean isBasicAuth(@Nonnull HttpAuthenticationSuccessContext context) {
        return "basic".equals(context.getMethod());
    }

    public static boolean isBasicAuth(@Nonnull HttpServletRequest request) {
        String authorization = request.getHeader(HEADER_AUTHORIZATION);
        return authorization != null && authorization.startsWith(AUTH_PREFIX_BASIC);
    }

    public static boolean isRestCall(@Nonnull HttpAuthenticationSuccessContext context) {
        return HttpAuthUtils.isRestCall(context.getRequest());
    }

    public static boolean isRestCall(@Nonnull HttpServletRequest request) {
        String relativeUrl = request.getRequestURI();
        if (StringUtils.isBlank((CharSequence)request.getContextPath()) || StringUtils.isBlank((CharSequence)relativeUrl)) {
            return false;
        }
        return (relativeUrl = relativeUrl.substring(request.getContextPath().length())).startsWith("/rest/") || relativeUrl.equals("/status");
    }

    @Nullable
    public static String getBasicAuthHeaderValue(@Nonnull HttpServletRequest request) {
        if (!HttpAuthUtils.isBasicAuth(request)) {
            return null;
        }
        return request.getHeader(HEADER_AUTHORIZATION).substring(AUTH_PREFIX_BASIC.length());
    }
}

