/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.user;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.rest.BadRequestException;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.fugue.Option;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.usersettings.UserSettings;
import com.atlassian.sal.api.usersettings.UserSettingsService;
import com.google.common.collect.ImmutableMap;
import com.sun.jersey.spi.resource.Singleton;
import java.util.Map;
import java.util.function.Function;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Path(value="users/{userSlug}/settings")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class UserSettingsResource {
    private static final Map<String, Object> EXAMPLE = ImmutableMap.builder().put((Object)"string key", (Object)"string value").put((Object)"boolean key", (Object)true).put((Object)"long key", (Object)10L).build();
    private static final Function<UserSettings, Map<String, Object>> TO_MAP = new Function<UserSettings, Map<String, Object>>(){

        @Override
        public Map<String, Object> apply(UserSettings input) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (String key : input.getKeys()) {
                builder.put((Object)key, this.getValueAsObject(input, key));
            }
            return builder.build();
        }

        private Object getValueAsObject(UserSettings userSettings, String key) {
            Option longSetting = userSettings.getLong(key);
            if (longSetting.isDefined()) {
                return longSetting.get();
            }
            Option stringSetting = userSettings.getString(key);
            if (stringSetting.isDefined()) {
                return stringSetting.get();
            }
            return userSettings.getBoolean(key).get();
        }
    };
    private final UserSettingsService userSettingsService;
    private final I18nService i18nService;

    public UserSettingsResource(UserSettingsService userSettingsService, I18nService i18nService) {
        this.userSettingsService = userSettingsService;
        this.i18nService = i18nService;
    }

    @GET
    public Response getUserSettings(@Context ApplicationUser user) {
        UserSettings userSettings = this.userSettingsService.getUserSettings(UserKey.fromLong((long)user.getId()));
        return ResponseFactory.ok(TO_MAP.apply(userSettings)).build();
    }

    @POST
    public Response updateSettings(@Context ApplicationUser user, Map<String, Object> settingsMap) {
        this.userSettingsService.updateUserSettings(UserKey.fromLong((long)user.getId()), builder -> {
            for (Map.Entry entries : settingsMap.entrySet()) {
                Object value = entries.getValue();
                if (value instanceof String) {
                    builder.put((String)entries.getKey(), (String)value);
                    continue;
                }
                if (value instanceof Integer || value instanceof Long) {
                    builder.put((String)entries.getKey(), ((Number)value).longValue());
                    continue;
                }
                if (value instanceof Boolean) {
                    builder.put((String)entries.getKey(), ((Boolean)value).booleanValue());
                    continue;
                }
                throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.usersettings.bad.type", new Object[]{value}));
            }
            return builder.build();
        });
        return ResponseFactory.noContent().build();
    }
}

