/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.user;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.rest.BadRequestException;
import com.atlassian.bitbucket.user.UserSearchRequest;
import com.atlassian.stash.internal.rest.util.RestPermissionUtils;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.ws.rs.core.MultivaluedMap;

public class RestUserSearchRequestParser {
    private static final int MAX_PERMISSION_FILTERS = 50;
    private static final String PARAM_FILTER = "filter";
    private static final String PARAM_PERMISSION = "permission";
    private static final String SUFFIX_PROJECT_ID = ".projectId";
    private static final String SUFFIX_PROJECT_KEY = ".projectKey";
    private static final String SUFFIX_REPOSITORY_ID = ".repositoryId";
    private static final String SUFFIX_REPOSITORY_SLUG = ".repositorySlug";
    private final I18nService i18nService;
    private final ProjectService projectService;
    private final RepositoryService repositoryService;

    public RestUserSearchRequestParser(I18nService i18nService, ProjectService projectService, RepositoryService repositoryService) {
        this.i18nService = i18nService;
        this.projectService = projectService;
        this.repositoryService = repositoryService;
    }

    @Nonnull
    public UserSearchRequest parse(@Nonnull MultivaluedMap<String, String> request) {
        Preconditions.checkNotNull(request, (Object)"request");
        UserSearchRequest.Builder requestBuilder = new UserSearchRequest.Builder().filter((String)request.getFirst((Object)PARAM_FILTER));
        int maxFilters = 50;
        if (this.maybeSetPermission(requestBuilder, request, PARAM_PERMISSION)) {
            --maxFilters;
        }
        for (int i = 1; i <= maxFilters && this.maybeSetPermission(requestBuilder, request, "permission." + i); ++i) {
        }
        return requestBuilder.build();
    }

    private Project getProjectOrFail(String projectKey, String context) {
        Project project = this.projectService.getByKey(projectKey);
        if (project == null) {
            throw new BadRequestException(context, this.i18nService.getMessage("bitbucket.rest.nosuchproject", new Object[]{projectKey}));
        }
        return project;
    }

    private Project getProjectOrFail(int projectId, String context) {
        Project project = this.projectService.getById(projectId);
        if (project == null) {
            throw new BadRequestException(context, this.i18nService.getMessage("bitbucket.rest.nosuchproject.byid", new Object[]{Integer.toString(projectId)}));
        }
        return project;
    }

    private Repository getRepositoryOrFail(String projectKey, String repositorySlug, String context) {
        Repository repository = this.repositoryService.getBySlug(projectKey, repositorySlug);
        if (repository == null) {
            throw new BadRequestException(context, this.i18nService.getMessage("bitbucket.rest.nosuchrepo", new Object[]{projectKey, repositorySlug}));
        }
        return repository;
    }

    private Repository getRepositoryOrFail(int repositoryId, String context) {
        Repository repository = this.repositoryService.getById(repositoryId);
        if (repository == null) {
            throw new BadRequestException(context, this.i18nService.getMessage("bitbucket.rest.nosuchrepo.byid", new Object[]{Integer.toString(repositoryId)}));
        }
        return repository;
    }

    private boolean maybeSetPermission(UserSearchRequest.Builder builder, MultivaluedMap<String, String> request, String permissionParam) {
        Permission permission = RestPermissionUtils.parsePermission(this.i18nService, (String)request.getFirst((Object)permissionParam), null, null, permissionParam);
        if (permission == null) {
            return false;
        }
        if (permission.isGlobal()) {
            builder.permission(permission);
            return true;
        }
        if (permission.isResource(Repository.class)) {
            return this.maybeSetRepositoryPermission(builder, request, permissionParam, permission);
        }
        if (permission.isResource(Project.class)) {
            return this.maybeSetProjectPermission(builder, request, permissionParam, permission);
        }
        throw new BadRequestException(permissionParam, this.i18nService.getMessage("bitbucket.rest.permission.unsupported", new Object[]{permission}));
    }

    private boolean maybeSetRepositoryPermission(UserSearchRequest.Builder builder, MultivaluedMap<String, String> request, String permissionParam, Permission permission) {
        String repositoryIdParam = permissionParam + SUFFIX_REPOSITORY_ID;
        if (request.containsKey((Object)repositoryIdParam)) {
            int repositoryId = this.parseInt(repositoryIdParam, (String)request.getFirst((Object)repositoryIdParam));
            builder.repositoryPermission(this.getRepositoryOrFail(repositoryId, repositoryIdParam), permission);
            return true;
        }
        String projectKey = (String)request.getFirst((Object)(permissionParam + SUFFIX_PROJECT_KEY));
        String repositorySlug = (String)request.getFirst((Object)(permissionParam + SUFFIX_REPOSITORY_SLUG));
        if (projectKey != null && repositorySlug != null) {
            builder.repositoryPermission(this.getRepositoryOrFail(projectKey, repositorySlug, permissionParam + SUFFIX_REPOSITORY_SLUG), permission);
            return true;
        }
        throw new BadRequestException(permissionParam, this.i18nService.getMessage("bitbucket.rest.permission.invalidrepositoryrequest", new Object[]{permissionParam}));
    }

    private boolean maybeSetProjectPermission(UserSearchRequest.Builder builder, MultivaluedMap<String, String> request, String permissionParam, Permission permission) {
        String projectIdParam = permissionParam + SUFFIX_PROJECT_ID;
        if (request.containsKey((Object)projectIdParam)) {
            int projectId = this.parseInt(projectIdParam, (String)request.getFirst((Object)projectIdParam));
            builder.projectPermission(this.getProjectOrFail(projectId, projectIdParam), permission);
            return true;
        }
        String projectKey = (String)request.getFirst((Object)(permissionParam + SUFFIX_PROJECT_KEY));
        if (projectKey != null) {
            builder.projectPermission(this.getProjectOrFail(projectKey, permissionParam + SUFFIX_PROJECT_KEY), permission);
            return true;
        }
        throw new BadRequestException(permissionParam, this.i18nService.getMessage("bitbucket.rest.permission.invalidprojectrequest", new Object[]{permissionParam}));
    }

    private int parseInt(String context, String intValue) {
        try {
            return Integer.parseInt(intValue);
        }
        catch (NumberFormatException e) {
            throw new BadRequestException(context, this.i18nService.getMessage("bitbucket.rest.nan", new Object[]{intValue}));
        }
    }
}

