/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.user;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionAdminService;
import com.atlassian.bitbucket.rest.BadRequestException;
import com.atlassian.bitbucket.rest.NotFoundException;
import com.atlassian.bitbucket.rest.RestResource;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractPermissionResource
extends RestResource {
    protected final PermissionAdminService permissionAdminService;
    protected final UserService userService;

    public AbstractPermissionResource(I18nService i18nService, PermissionAdminService permissionAdminService, UserService userService) {
        super(i18nService);
        this.permissionAdminService = permissionAdminService;
        this.userService = userService;
    }

    protected Permission validatePermission(String permissionName, Class<?> resourceClass) {
        Permission permission;
        if (permissionName == null) {
            String message = this.i18nService.getMessage("bitbucket.rest.permissionadmin.missingpermission", new Object[0]);
            throw new BadRequestException(message);
        }
        try {
            permission = Permission.valueOf((String)permissionName.toUpperCase().replace('-', '_'));
        }
        catch (IllegalArgumentException e) {
            String message = this.i18nService.getMessage("bitbucket.rest.permissionadmin.invalidpermission", new Object[]{permissionName});
            throw new BadRequestException(message);
        }
        if (resourceClass != null && !permission.isResource(resourceClass)) {
            String message = this.i18nService.getMessage("bitbucket.rest.permission.admin.notapplicablewithresource", new Object[]{permission.name(), resourceClass});
            throw new BadRequestException(message);
        }
        if (resourceClass == null && !permission.isGlobal()) {
            String message = this.i18nService.getMessage("bitbucket.rest.permission.admin.notapplicablewithoutresource", new Object[]{permission.name()});
            throw new BadRequestException(message);
        }
        if (!permission.isGrantable()) {
            String message = this.i18nService.getMessage("bitbucket.rest.permissionadmin.ungrantablepermission", new Object[]{permission.name()});
            throw new BadRequestException(message);
        }
        return permission;
    }

    protected String validateGroup(String groupName, boolean allowNonExistent) {
        if (StringUtils.isEmpty((CharSequence)groupName)) {
            String message = this.i18nService.getMessage("bitbucket.rest.permission.admin.invalidgroup", new Object[0]);
            throw new BadRequestException(message);
        }
        if (!allowNonExistent && !this.userService.existsGroup(groupName)) {
            String message = this.i18nService.getMessage("bitbucket.rest.permission.nosuchgroup", new Object[]{groupName});
            throw new NotFoundException(message);
        }
        return groupName;
    }

    protected Set<String> validateGroups(Set<String> groupNames, boolean allowNonExistent) {
        if (groupNames == null || groupNames.isEmpty()) {
            String message = this.i18nService.getMessage("bitbucket.rest.permission.no.groups", new Object[0]);
            throw new BadRequestException(message);
        }
        HashSet<String> groups = new HashSet<String>(groupNames.size());
        ArrayList<String> missing = new ArrayList<String>();
        for (String groupName : groupNames) {
            try {
                groups.add(this.validateGroup(groupName, allowNonExistent));
            }
            catch (NotFoundException e) {
                missing.add(groupName);
            }
        }
        if (!missing.isEmpty()) {
            String message = this.i18nService.getMessage("bitbucket.rest.permission.nosuchgroups", new Object[]{StringUtils.join(missing, (String)", ")});
            throw new NotFoundException(message);
        }
        return ImmutableSet.copyOf(groups);
    }

    protected ApplicationUser validateUser(String username, boolean returnDeleted) {
        if (StringUtils.isEmpty((CharSequence)username)) {
            String message = this.i18nService.getMessage("bitbucket.rest.permission.admin.invaliduser", new Object[0]);
            throw new BadRequestException(message);
        }
        ApplicationUser user = this.userService.getUserByName(username, returnDeleted);
        if (user == null) {
            String message = this.i18nService.getMessage("bitbucket.rest.permission.nosuchuser", new Object[]{username});
            throw new NotFoundException(message);
        }
        return user;
    }

    protected Set<ApplicationUser> validateUsers(Collection<String> usernames, boolean returnDeleted) {
        if (usernames == null || usernames.isEmpty()) {
            String message = this.i18nService.getMessage("bitbucket.rest.permission.no.users", new Object[0]);
            throw new BadRequestException(message);
        }
        HashSet<ApplicationUser> users = new HashSet<ApplicationUser>(usernames.size());
        ArrayList<String> missing = new ArrayList<String>();
        for (String username : usernames) {
            try {
                users.add(this.validateUser(username, returnDeleted));
            }
            catch (NotFoundException e) {
                missing.add(username);
            }
        }
        if (!missing.isEmpty()) {
            String message = this.i18nService.getMessage("bitbucket.rest.permission.nosuchusers", new Object[]{StringUtils.join(missing, (String)", ")});
            throw new NotFoundException(message);
        }
        return ImmutableSet.copyOf(users);
    }
}

